// Swarm library. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/* 
  VNneighbor.m

  Barry McMullin <mcmullin@eeng.dcu.ie>
  26-SEP-1996

*/

#import <random.h>
#import "VNneighbor.h"


@implementation VNneighbor


/* 
   The -next, -previous and -randomise methods *could* be made
   marginally more efficient if they took advantage of the
   underlying ordering of the neighbor_t enumerated type;
   but that would then mean that any change in that underlying
   ordering would (silently) break the VNneighbor class.
   I prefer to accept the small performace penalty in making
   this class robust against changes in the underlying ordering
   of neighbor_t.
*/


- (neighbor_t)next: (neighbor_t)inNeighbor
{
  neighbor_t nextNeighbor = North;

  switch (inNeighbor)
    {
    case North: nextNeighbor = East;    break;
    case East:  nextNeighbor = South;   break;
    case South: nextNeighbor = West;    break;
    case West:  nextNeighbor = North;   break;
    default:
      [InternalError
        raiseEvent:
          "Invalid von Neumann neighbor code (%d) encountered.\n", 
        nextNeighbor];
    }
  
  return (nextNeighbor);
}

- (neighbor_t)previous: (neighbor_t)inNeighbor
{
  neighbor_t previousNeighbor = North;
  
  switch (inNeighbor)
    {
    case North: previousNeighbor = West;    break;
    case West:  previousNeighbor = South;   break;
    case South: previousNeighbor = East;    break;
    case East:  previousNeighbor = North;   break;
    default:
      [InternalError
        raiseEvent:
          "Invalid von Neumann neighbor code (%d) encountered.\n", 
        previousNeighbor];
    }
  return previousNeighbor;
}


- (neighbor_t)random
{
  int randomNumber;
  neighbor_t randomNeighbor;
  
  randomNumber = [uniformIntRand getIntegerWithMin: 0L withMax: 3L];
  switch (randomNumber)
    {
    case 0: randomNeighbor = North;    break;
    case 1: randomNeighbor = East;     break;
    case 2: randomNeighbor = South;    break;
    case 3: randomNeighbor = West;     break;
    default:
      [InternalError
        raiseEvent:
          "Out-of-range random number (%d) encountered.\n", randomNumber];
      randomNeighbor = North; // Defensive...
    }
  
  return randomNeighbor;
}

@end
