// Swarm library. Copyright (C) 1996-1999 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/* 
  neighbor.h

  Barry McMullin <mcmullin@eeng.dcu.ie>
  23-SEP-1996


  This header just defines the enumerated type neighbor_t
  This type provides symbolic (and possibly even meaningful)
  names for neighboring cells in a 2d rectangular lattice.
  That's all.

 "Center" refers to the agent2d itself; its somewhat
  redundant to include it as a "neighbor", but it may
  simply some iterative precedures. "FarNorth" is *two*
  cells North, etc.

*/

typedef enum { 
   Center,
   North, East, South, West, 
   NorthEast, SouthEast, SouthWest, NorthWest,
   FarNorth, FarEast, FarSouth, FarWest
  } neighbor_t;
   
