// Hello, World! application. Copyright (C) 1996-1999 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import "PplObserverSwarm.h"
#import <analysis.h> // ActiveGraph
#import <gui.h>

// implementation of sample graphical interface for models.
@implementation PplObserverSwarm

+ createBegin: aZone
{
  PplObserverSwarm * obj;
  id <ProbeMap> probeMap;
  
  obj = [super createBegin: aZone];

  // MODIFY: initialize other display options here.
  obj->displayFrequency = 1;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  // MODIFY: set any display parameters here.
  [probeMap addProbe: [probeLibrary getProbeForVariable: "displayFrequency"
				    inClass: [self class]]];

  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

// MODIFY: possible creation finalization here
- createEnd
{
  return [super createEnd];
}

- buildObjects
{
  id modelZone;

  [super buildObjects];
  
  // allocate space to hold the model
  modelZone = [Zone create: [self getZone]];


  // create the modelswarm as a subzone in the modelzone
  pplModelSwarm = [PplModelSwarm create: modelZone];
  
  // create the probedisplay manager for the model swarm
  CREATE_PROBE_DISPLAY (pplModelSwarm);
  // create the probe display for the observer swarm (self)
  CREATE_PROBE_DISPLAY (self);

  // set the control panel state
  [actionCache waitForControlEvent];
  // test to see if the "quit" button was hit
  if ([controlPanel getState] == ControlStateQuit)
    return self;

  // build the objects defined in PplmodelSwarm.m
  [pplModelSwarm buildObjects];

  // display the counter
  observedCounter = [pplModelSwarm getCounter];


  // creat a graph of numberPplStillTalking using the BLT
  // graph straight out of the library
  pplLeftGraph = [Graph create: [self getZone]];
  [pplLeftGraph setTitle: "Number of Ppl Still Talking"];
  [pplLeftGraph setAxisLabelsX: "Cycle" Y: "Number Left"];
  [pplLeftGraph setWidth: 400 Height: 250];
  [pplLeftGraph pack];
  [pplLeftGraph setScaleModeX: 1 Y: 0];

  // put the element on the graph
  numberLeft = [pplLeftGraph createElement];
  [[[numberLeft setLabel: "Number Left"] setColor: "green"]
    setWidth: 3];
  pplLeftGrapher = [ActiveGraph createBegin: [self getZone]];
  [pplLeftGrapher setElement: numberLeft];
  [pplLeftGrapher setDataFeed: pplModelSwarm];
  [pplLeftGrapher setProbedSelector: M(getNumberPplStillTalking)];
  pplLeftGrapher = [pplLeftGrapher createEnd];


  return self;
}  

- buildActions
{
  // build the actions for the observer's schedule
  [super buildActions];
  
  // build the actions for the model's schedule
  [pplModelSwarm buildActions];

  // create the display actions
  displayActions = [ActionGroup create: [self getZone]];
  // update the counter
  [displayActions createActionTo: observedCounter     message: M(print)];
  // update the graph
  [displayActions createActionTo: pplLeftGrapher      message: M(step)];
  // check to see if everybody's done talking
  [displayActions createActionTo: self                message: M(checkToStop)];
  // update the probes
  [displayActions createActionTo: probeDisplayManager message: M(update)];
  // check the controlpanel for clicks
  [displayActions createActionTo: actionCache         message: M(doTkEvents)];

  // then actually schedule the display actions
  displaySchedule = [Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];

  return self;
}  

- activateIn: swarmContext
{
  // put self (observer swarm) on the schedule of the GUI swarm
  [super activateIn: swarmContext];
  
  // start the activity for the model swarm
  [pplModelSwarm activateIn: self];
  // start the display schedule
  [displaySchedule activateIn: self];
  
  return [self getSwarmActivity];
}

// this method queries the pplModelSwarm to find out if everybody
// has sent the ImFinished message to the modelswarm.  If so,
// then stop the sim because nobody's talking.
- checkToStop
{
  if ([pplModelSwarm getNumberPplStillTalking] <= 0)
    {
      (void)printf ("Party's over!  You don't have to go home;"
                    "  but you can't stay here.\n");
      [controlPanel setStateStopped];
    }
  return self;
}

@end
