// Template application. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <objectbase.h>
#import <objectbase/Swarm.h>
#import "Counter.h"

// Sample model swarm - in this case, create one counter and schedule it.

@interface TemplateModelSwarm: Swarm
{
  // MODIFY: add your own simulation parameters
  int increment;

  id modelActions;
  id modelSchedule;

  // MODIFY: add your own model objects.  
  Counter *counter;
}

// MODIFY: add access methods for what agents are visible.
- (Counter *)getCounter;

+ createBegin: aZone;
- createEnd;
- buildObjects;
- buildActions;
- activateIn: swarmContext;

@end
