// Market application. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#include "define.h"
#include "extern.h"
#import <random.h>

/* ------------------------------------------------------------------------------------*/	
void Initiate_history(float * past){	/* Sets up the historical prices and
										 when called, puts in pastdays array.
										Note:		0 is the most recent day.	 	*/
										
	int i;																			
	for ( i = HISTORY_LENGTH - 1; i >= 0; i--)	{	
		past[i] = INITIAL_HIST;
	} 
}
/* ------------------------------------------------------------------------------------*/	

void Update_history(float *past,float newprice){
 
	/* Updates price history array by adding latest price (newnumber) to end
		 and dropping earliest day. Note: 0 is most recent day						*/
		
	int i;

	for (i = HISTORY_LENGTH-1; i>0 ; i--) 
		past[i] = past[i-1];	
	past[0] = newprice; 
}
/* ------------------------------------------------------------------------------------*/	

void fprint_history(float *past)	{
	int i = HISTORY_LENGTH -1;
	fprintf(ofp,"\n History: ");
	for (; i >=0 ; i--)	{
		if ((HISTORY_LENGTH -i) % 25 ==24)	fprintf(ofp,"\n");	
		fprintf(ofp," %4.1f", pastdays[i]);
	}
	fprintf(ofp,"\n");
}
/* ------------------------------------------------------------------------------------*/	

void print_history(float *past)	{
	int i = HISTORY_LENGTH -1;
	printf("\nHistory:");
	for (; i >=0 ; i--)	{
/*		if ((HISTORY_LENGTH -i) % 25 ==24)	printf("\n");     */	
		printf("%6.1f", pastdays[i]);
	}
}

/* ------------------------------------------------------------------------------------*/	
