// Market application. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import "Market.h"
#include "global.h"

int   MAXHEED		= 7;	/* Total predictors each agent notices	*/
double ETA		= 0.1;	/* Rate for updating predictor accurs. */
double BETA		= 0.9;	/* Discount rate */
double NU		= 10.0;	/* Multiplier for dividend jumps */
double INITIAL_DIVIDEND	= 20.0;
int   pr_text		= 1;	// print Brian Arthur's text output


 prediction forecast[TOTPREDICTORS];		/*	The current predictors'forecasts 	*/
 hombre  person[TOTPERSONS];				/*	The population of agents			*/
 float pastdays[HISTORY_LENGTH];			/*	Array of past prices 				*/
 int predictor_use[TOTPREDICTORS];			/*  Counts no. of agents using predictor*/
 float todays_price;						/*  New price 							*/
 float Dividend;								/*  Current dividend					*/
 const char *pred[] = {"Trend    ", "Last + 10","Smart trend", "2 period trend",
 	"Fundamental","Av. prev 3","Same last   ", "2 cycle   ","3 cycle   ","4 cycle   ",
 	"5 cycle   ","6 cycle   ","7 cycle   ","8 cycle   ","9 cycle   ","10 cycle  "} ;
 FILE *ofp, *ofplot;
 int day;
 
@implementation Market

- stepMarket {
  Make_new(forecast);						/* Each predictor makes new forecast		*/
						
  Choose_Best_Predictors(forecast,person);/* Agents choose their most accurate forecaster	*/
	
  Count_Predictor_Use (person,predictor_use);
	
  Dividend 	= 	Declare_New_Dividend(Dividend);
	
  todays_price =  Make_New_Price(forecast, person); 
/*		fprintf(ofplot, "\n%d",todays_price);    */
	
/*	Make_Report(day, pastdays, todays_price, forecast, person, predictor_use);		*/

  Update_accuracy(todays_price,forecast);			/* Reassess accuracy and ranks	*/
  sort(forecast);

  Update_history(pastdays,todays_price);			/* Update price history	*/
			
  if (pr_text) {
    if (NEED_TO_REPORT) {
      printf("\n Day%3d", day);
      print_forecasts(forecast,predictor_use);
      print_history(pastdays); 
      printf("\n Dividend = %3.2f", Dividend); 							
      // getchar();
    }
  }			
  ++day; 							/*  Loop to next day 			*/
  return self;
} 

@end
