// Hello, World! application. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <simtoolsgui/GUISwarm.h>
#import <analysis.h>
#import <gui.h>
#import <space.h>
#import "PplModelSwarm.h"

// Sample graphical interface swarm for models.
@interface PplObserverSwarm: GUISwarm
{
  int displayFrequency;

  id displayActions;
  id displaySchedule;

  // add the modelswarm to the observer swarm
  PplModelSwarm *pplModelSwarm;
  // add the counter to the observer swarm
  Counter *observedCounter;

  // add the numberPplStillTalking graph to obs swarm
  id <Graph> pplLeftGraph;
  id <GraphElement> numberLeft;
  id <ActiveGraph> pplLeftGrapher;

  // add the number of friends averager
  id <EZGraph> avgFriendGraph;

  // add the space viewer objects
  id <Colormap> colormap;
  id <ZoomRaster> worldRaster;
  id <Object2dDisplay> pplDisplay;
}

+ createBegin: aZone;
- createEnd;
- buildObjects;
- buildActions;
- activateIn: swarmContext;

// checks to see if everybody's done talking
- checkToStop;

@end
