// Hello, World! application. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// This is the header file for the Person agent.  It defines the 
// instance variables and everything else the Person needs to work
// in the world.
#import <objectbase/SwarmObject.h>
#import <collections/String.h>

// define a type to help index conversation subjects
typedef enum { 
  null = 0,       // no topic
  hello = 1,      // say hello
} topic_type;


// define the methods a person can execute  These are defined in 
// Person.m
@interface Person: SwarmObject
{
  id world;
  float topics[2];
  int value;
  id name;  // person's name
}

// move one time step forward
- step;

// set the environment up so that the agent can receive sensory input
- setWorld: l;

// set the agent up with the parameters given
- setPerson: n Topic_array: (float *)t;

// get the person's name
- (const char *)getName;

// print info about the person
- print;

// say something to somebody
- speak: (topic_type) topic ToPerson: (id)target;

// look around for someone to talk to
- look;

@end
