// Hello, World! application. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <space.h>
#import <swarmobject.h>
#import "Counter.h"
#import "Person.h"
// include the neighborhood object 
#import "VNneighbor.h"
// declare an external neighbor to use
extern VNneighbor * vnneighbor;

@interface PplModelSwarm : Swarm
{
  // MODIFY: add your own simulation parameters
  int increment;

  // these are variables specific to the modelswarm that
  //  carry info about the overall model
  int numPpl;
  int numberPplStillTalking;

  // declare a list in which party-goers will reside
  id pplList;
  // declare a space for the room (I put world in there so
  // that I wouldn't have to re-define all the Agent2d methods
  DiscreteToroid * world, * room;
  // declare vars for the room
  int worldXSize, worldYSize;
  int doorX, doorY;            // door coord
  int displayConversations;   // 0 by default

  id modelActions;
  id modelSchedule;

  // MODIFY: add your own model objects.  
  Counter * counter;
}

// MODIFY: add access methods for what agents are visible.
- (Counter *)getCounter;
- getPplList;
- (DiscreteToroid *)getWorld;
+ createBegin: aZone;
- createEnd;
- buildObjects;
- buildActions;
- activateIn: swarmContext;

// message from people saying their done talking
- ImFinished;
// method for passing how many are talking back to observer
- (int)getNumberPplStillTalking;

@end

