// Market application. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import "global.h"
#import "define.h"
#import "extern.h"
#import "MarketModelSwarm.h"
#import "Market.h"

// This code is pretty messy, legacy code from an old model
// lots of global variables that we're passing back, but should be
// encapsulated somewhere between the model swarm and the Market object

@implementation MarketModelSwarm

-(double) getPrice {
  return todays_price;
}

-(double) getDividend {
  return Dividend;
}

-(double) getFundamental {
  return forecast[4].numbers;
}

-(int *) getPredictorUse {
  return predictor_use;
}

+createBegin: (id) aZone {
  MarketModelSwarm * obj;
  ProbeMap * probeMap;

  obj = [super createBegin: aZone];

  // copy global variables in
  NU = 0.1;
  obj->numPredictors = MAXHEED;
  obj->accuracyUpdateRate = ETA;
  obj->discountRate = BETA;
  obj->dividendJumpScale = 10.0;
  day = 1;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  // MODIFY: add your own probes for your parameters.
  [probeMap addProbe: [probeLibrary getProbeForVariable: "numPredictors"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "accuracyUpdateRate"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "discountRate"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "dividendJumpScale"
				    inClass: [self class]]];
  [probeLibrary setProbeMap: probeMap For: [self class]];
  
  return obj;
}

-buildObjects {
  [super buildObjects];

  // copy global variables back
  MAXHEED = numPredictors;
  ETA = accuracyUpdateRate;
  BETA = discountRate;
  NU = dividendJumpScale;
  
  aMarket = [Market alloc];
  Initiate_history(pastdays);		     /* read in the initial history */
	
  Initiate_predictors(forecast);	     /* set up the predictors */
  sort(forecast);

  Initiate_agents(person);	    /* set up agents with their predictors */

  Dividend = INITIAL_DIVIDEND;


  return self;
}

-buildActions {
  [super buildActions];

  // MODIFY: schedule your own agents as appropriate.
  modelActions = [ActionGroup create: [self getZone]];
  [modelActions createActionTo: aMarket message: M(stepMarket)];

  modelSchedule = [Schedule createBegin: [self getZone]];
  [modelSchedule setRepeatInterval: 1];
  modelSchedule = [modelSchedule createEnd];
  [modelSchedule at: 0 createAction: modelActions];

  return self;
}

-activateIn: (id) swarmContext {
  [super activateIn: swarmContext];

  [modelSchedule activateIn: self];

  return [self getSwarmActivity];
}

@end
