#import "grid.h"
#import <activity/SwarmProcess.h>
#import <activity.h>

#define __USE_FIXED_PROTOTYPES__   // for gcc headers
#include <stdio.h>

static void terminateFunction( void )
{
  [getTopLevelActivity() terminate];
}

static void stopFunction( void )
{
  printf( "stopping activity at time: %lu\n", getCurrentTime() );
  [getTopLevelActivity() stop];
}

int main(void)
{
  id   aZone, aTurtle;
  id   simSched1, simSched2, displaySchedule, terminateSchedule;
  id   simSwarm, obsSwarm, obsSwarmActivity;

  // initialize

  initModule( grid );
  initModule( activity );

  aZone = [Zone create: globalZone];
  obsSwarm = [SwarmProcess create: aZone];
  simSwarm = [SwarmProcess create: obsSwarm];

  _activity_zone = [Zone create: globalZone];

  // create a turtle to turn and move during simulation

  aTurtle = [GridTurtle create: simSwarm];

  // create a pair of simulation schedules (repeat intervals of 2 and 4)

  simSched1 = [Schedule createBegin: simSwarm];
  [simSched1 setRepeatInterval: 2];
  simSched1 = [simSched1 createEnd];
  [simSched1 at: 0 createActionTo: aTurtle message: M(move:) : (id)10];

  simSched2 = [Schedule createBegin: simSwarm];
  [simSched2 setRepeatInterval: 4];
  simSched2 = [simSched2 createEnd];
  [simSched2 at: 0 createActionTo: aTurtle message: M(turn:) : (id)1];

  // create a display schedule to print turtle at every time step

  displaySchedule = [Schedule createBegin: obsSwarm];
  [displaySchedule setRepeatInterval: 1];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createActionTo: aTurtle message: M(print)];

  // create a schedule to terminate all activity at timestep 32

  terminateSchedule = [Schedule create: obsSwarm];
  [terminateSchedule at: 8 createActionCall: stopFunction];
  [terminateSchedule at: 11 createActionCall: terminateFunction];

  obsSwarmActivity = [obsSwarm activateIn: nil];
  [obsSwarm activate: terminateSchedule];
  [obsSwarm activate: displaySchedule];

  [obsSwarm activate: simSwarm];
  [simSwarm activate: simSched1];
  [simSwarm activate: simSched2];

  // run the top-level swarm to completion

  while ( [obsSwarmActivity next] != Completed );

  [obsSwarmActivity drop];
  [_activity_zone xprint];

  [aTurtle drop];
  [simSched1 drop];
  [simSched2 drop];
  [simSwarm drop];
  [displaySchedule drop];
  [terminateSchedule drop];

  [[obsSwarm getInternalZone] xprint];
  [[obsSwarm getInternalZone] xfprint];
  [obsSwarm drop];

  [aZone xprint];
  [aZone drop];
  return 0;
}
