#import "grid.h"
#import <activity.h>
#import <activity/XActivity.h>

#define __USE_FIXED_PROTOTYPES__   // for gcc headers
#include <stdio.h>

extern BOOL respondsTo( id, SEL );  // from defobj

static BOOL trace( id anActivity );

static id newTurtle( void )
{
  id          aTurtle;
  static int  ycoord;

  aTurtle = [GridTurtle create: globalZone];
  [aTurtle move: ++ycoord];
  return aTurtle;
}

int main(void)
{
  id   aZone, aList, aTurtle;
  id   emptyActions1, emptyActions2;
  id   moveAndPrint, moveActions, printActions;
  id   printRelative, printRepeat, startSchedule;
  id   swarm, swarmActivity, status;
  int  i;

  initModule( grid );
  initModule( activity );

  aZone = [Zone create: globalZone];
  swarm = [SwarmProcess create: aZone];
  _activity_zone = [Zone create: globalZone];

  aList = [List create: swarm];

  for ( i = 0; i < 10; i++ ) {
    aTurtle = [GridTurtle create: swarm];
    [aTurtle turn: -1];
    [aTurtle move: i * 10];
    [aTurtle turn: 1];
    [aList addLast: aTurtle];
  }

  moveActions = [ActionGroup create: swarm];
  for ( i = 0; i < 10; i++ ) {
    if ( i % 2 )
      [moveActions
        createActionTo: [aList atOffset: i] message: M(move:) : (id)10 ];
  }

  printActions = [ActionGroup create: swarm];
  for ( i = 0; i < 10; i++ ) {
    [printActions createActionTo: [aList atOffset: i] message: M(print)];
  }

  moveAndPrint = [Schedule createBegin: swarm];
  [moveAndPrint setRepeatInterval: 10];
  moveAndPrint = [moveAndPrint createEnd];

  [moveAndPrint at: 0 createAction: moveActions];
  [moveAndPrint at: 0 createAction: printActions];

  emptyActions1 = [ActionGroup create: swarm];
  emptyActions2 = [ActionGroup create: swarm];

  printRelative = [Schedule createBegin: swarm];
  [printRelative setRelativeTime: 1];
  printRelative = [printRelative createEnd];

  [printRelative at: 0 createActionTo: newTurtle() message: M(print)];
  [printRelative at: 4 createAction: emptyActions1];
  [printRelative at: 4 createActionTo: newTurtle() message: M(print)];
  [printRelative at: 9 createActionTo: newTurtle() message: M(print)];

  printRepeat = [Schedule createBegin: swarm];
  [printRepeat setRepeatInterval: 10];
  printRepeat = [printRepeat createEnd];

  [printRepeat at: 0 createActionTo: newTurtle() message: M(print)];
  [printRepeat at: 1 createActionTo: newTurtle() message: M(print)];

  startSchedule = [Schedule create: swarm];
  [startSchedule at: 1 createAction: printRepeat];
  [startSchedule at: 2 createActionTo: newTurtle() message: M(print)];
  [startSchedule at: 2 createAction: emptyActions2];

  [startSchedule at: 2 createAction: printRelative];
  [startSchedule at: 18 createAction: printRelative];
  [startSchedule at: 21 createAction: printRelative];
  [startSchedule at: 34 createAction: printRelative];

  [startSchedule at: 5 createActionTo: newTurtle() message: M(print)];
  [startSchedule at: 12 createActionTo: newTurtle() message: M(print)];
  [startSchedule at: 18 createActionTo: newTurtle() message: M(print)];
  [startSchedule at: 10 createActionTo: newTurtle() message: M(print)];
  [startSchedule at: 20 createActionTo: newTurtle() message: M(print)];

  _activity_trace = trace;
  swarmActivity = [swarm activateIn: nil];
  [swarm activate: startSchedule];

  while ( (status = [swarmActivity run]) != Stopped && status != Completed );
  printf( "run return status: %s\n", [status getName] );

  [swarmActivity drop];
  [_activity_zone xprint];

  [moveActions drop];
  [printActions drop];
  [moveAndPrint drop];
  [emptyActions1 drop];
  [emptyActions2 drop];

  [printRelative drop];
  [printRepeat drop];
  [startSchedule drop];

  [aList deleteAll];
  [aList drop];
  [[swarm getInternalZone] xprint];
  [swarm drop];
  return 0;
}

static BOOL trace( id anActivity )
{
  id         swarmActivity, string;
  int        level;
  timeval_t  currentTime = 999999;
  char       buffer[100];

  for ( swarmActivity = anActivity, level = 0;
        ! respondsTo( swarmActivity, @selector( getSynchronizationSchedule ) );
        swarmActivity = [swarmActivity getOwnerActivity], level++ );

  currentTime = getCurrentTime();

  if ( swarmActivity != getCurrentSwarmActivity() ||
       currentTime != [getCurrentScheduleActivity() getCurrentTime] )
    raiseEvent( SourceMessage, "context macro mismatch\n" );

  _obj_formatIDString( buffer, anActivity );
  if ( [anActivity getStatus] == Running ) {
    [getCurrentAction() describe: (string = [String create: scratchZone])];
    printf( "at time: %lu, level %d, %s, %s",
             currentTime, level, buffer, [string getC] );
    [string drop];
  } else {
    printf( "at time: %lu, level %d, %s is %s\n",
             currentTime, level, buffer, [[anActivity getStatus] getName] );
  }
  if ( currentTime < 100 ) return 0;
  ((Activity_c *)anActivity)->status = Stopped;
  return 1;
}
