#import "grid.h"

#define __USE_FIXED_PROTOTYPES__   // for gcc headers
#include <stdio.h>

int main(void)
{
  id aZone, aSet, aTurtle, turtles[10], index;
  int i;

  initModule( grid );

  aZone = [Zone create: globalZone];
  aSet  = [Set create: aZone];

  printf( "count: %d\n", [aSet getCount] );

  for ( i = 0; i < 10; i++ ) {
    aTurtle = [GridTurtle create: aZone];
    turtles[i] = aTurtle;
    [aTurtle turn: -1];
    [aTurtle move: i * 10];
    if ( i & 1 ) [aSet add: aTurtle];
  }

  printf( "count: %d\n", [aSet getCount] );

  index = [aSet begin: aZone];
  while ( (aTurtle = [index next]) ) {
    [aTurtle print];
  }
  for ( i = 0; i < 10; i++ ) {
    if ( [aSet at: turtles[i]] != turtles[i] ) {
      printf( "turtle not found at %d\n", i );
    }
  }

  for ( i = 0; i < 10; i++ ) {
    if ( i & 1 ) {
      [aSet remove: turtles[i]];
    } else {
      [aSet add: turtles[i]];
    }
  }
  index = [aSet begin: scratchZone];
  while ( (aTurtle = [index next]) ) {
    [aTurtle print];
  }
  for ( i = 0; i < 10; i++ ) {
    if ( [aSet at: turtles[i]] != turtles[i] ) {
      printf( "turtle not found at %d\n", i );
    }
  }
  [index drop];

  [aSet xprint];
  [aSet drop];
  [aZone xprint];
  [aZone drop];
  return 0;
}
