#import "grid.h"

#include <stdio.h>

int main(void)
{
  id    aZone, aMap, aTurtle, key, index;
  int   i;
  char  buffer[10];

  initModule( grid );

  aZone = [Zone create: globalZone];
  aMap  = [Map create: aZone];

  printf( "count: %d\n", [aMap getCount] );

  for ( i = 0; i < 10; i++ ) {
    aTurtle = [GridTurtle create: aZone];
    [aTurtle turn: -1];
    [aTurtle move: i * 10];
    sprintf( buffer, "%d", i );
    key = [String create: aZone setC: buffer];
    [aMap at: key insert: aTurtle];
  }

  printf( "count: %d\n", [aMap getCount] );

  index = [aMap begin: scratchZone];
  while ( (aTurtle = [index next]) ) {
    key = [index getKey];
    printf( "%s: ", [key getC] );
    [aTurtle print];
    [key drop];
  }

  [[aMap getFirst] print];
  [[aMap getLast] print];

  [aMap xprint];
  [aMap drop];
  [aZone xprint];
  [aZone drop];
  return 0;
}
