// TwoD.h

// Copyright  1996-2000 Swarm Development Group.
// No warranty implied, see LICENSE for terms.

#import <objectbase/SwarmObject.h>
//
//    0-----------------> v
//    |
//    | 
//    |        C
//  . |
//    |
//    u
// 
// C is the center of the image plane: (u, v) = (256, 256) in pixels
//
@interface Point2D: SwarmObject
{
  int HeapHeight; // heigth
  int v; // width in pixel now
  int u; // height in pixel now
  int lab; // name
}

// fill in the object with appropriate computed values
- fill:  (int)_u: (int)_v: (int)_h: (int)_num;

// print features of an imaged 3D object
- print;

// send features of an imaged 3D object
- (int)sendu;
- (int)sendv;
- (int)sendHeapHeight;
- (int)sendlab;

@end
