// Intrinsic.h

// Copyright  1996-2000 Swarm Development Group.
// No warranty implied, see LICENSE for terms.

#import <objectbase/SwarmObject.h>
#import <math.h>

@interface Intrinsic: SwarmObject
{
  float f; // camera lens
  float ku; // ku, for vertical axis in image plane
  float kv; // kv, for horizontal axis in image plane
  int u0; //coordinates in pixels of the image center: (u0, v0)
  int v0;
}

// initialize the data, that is the 5 basic intrinsic parameters
- initialize: (float)lens: (float)Ku: (float)Kv: (int)U_0: (int)V_0;

// send parameters
- (float)sendf;
- (float)sendku;
- (float)sendkv;
- (int)sendu0;
- (double)sendv0;

// modify parameters
- modifyf: (float)newf;
- modifyku: (float)newku;
- modifykv: (float)newkv;
- modifyu0: (int)newu0;
- modifyv0: (int)newv0;

// to know the view angle of camera, once initialized
- (double)ViewAngle;

// print intrinsic parameters of camera
- print;

@end
