// AgentObserverSwarm.h
// Swarm room 1996

#import <simtoolsgui/GUISwarm.h>
#import <simtoolsgui.h>
#import <analysis.h>
#import "village.h"
#import "AgentModelSwarm.h"

@interface AgentObserverSwarm : GUISwarm
{
  int displayFrequency;				// one parameter: update freq
  int zoomFactor;				// display resolution

  id displayActions;				// schedule data structs
  id displaySchedule;

  AgentModelSwarm *agentModelSwarm;		// the Swarm we're observing

  // Lots of display objects. First, widgets
  id <Colormap> colormap;			// allocate colours
  id <ZoomRaster> worldRaster;			// 2d display widget
  id <EZGraph> avgGraph;			// graphing widget
  id <EZGraph> yieldGraph;		  	// graphing widget
  id <EZGraph> popGraph;		  	// graphing widget

  // Now, higher order display and data objects
  // Value2dDisplay * heatDisplay;		// display the heat
  id <Object2dDisplay> cellDisplay;		// display the cells
  id <Object2dDisplay> agentDisplay;		// display the agents
}

// Methods overriden to make the Swarm.
+ createBegin: aZone;

// create the probe maps for objects
+ setAgentObserverSwarmProbeMap: aZone;
+ setAgentModelSwarmProbeMap: aZone;
+ setCellProbeMap: aZone;
+ setAgentProbeMap: aZone;

- createEnd;

- buildObjects;
- buildActions;
- activateIn: swarmContext;

// display stuff
- (int)displayMaize;
- (int)displayElevation;
- (int)displaySoil;
- (int)displayWater;
- (int)displayElevWater;
- (int)displaySoilWater;

@end
