// Turmites application. Copyright  1996-2000 Swarm Development Group.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// The TurmiteBatchSwarm is an alternative to the TurmiteObserverSwarm
// It's also a toplevel swarm that directs execution of a model, but it
// operates without any graphics - just does file I/O to store data.

#import "TurmiteModelSwarm.h"

#include <stdio.h>

@interface TurmiteBatchSwarm: Swarm
{
  int displayFrequency;				  // one parameter: update freq

  id displayActions;				  // schedule data structs
  id displaySchedule;
  id stopSchedule;

  TurmiteModelSwarm * turmiteModelSwarm;	  // the Swarm we're observing

//   Averager * unhappinessAverager;		  // data collection object

  FILE * outputFile;				  // and a file to store data
}

+ createBegin: aZone;
- buildObjects;
- buildActions;
- activateIn: swarmContext;
- go;

// special message on ourselves to stop running.
- stopRunning;

// special data write method
- writeData;

@end
