#include <misc.h>

#import <simtools.h>                // ... for initSwarm() and swarmGUIMode
#import "Version.h"
#import "Globals.h"

int
main (int argc, const char **argv)
{
  initSwarm (argc, argv);
  
  [Version printCopyright];
  
  if (!swarmGUIMode)
    [InternalError raiseEvent:
    "TipsyBugs can run only in GUIMode - sorry!\n"];

  modelSwarm = [ModelSwarm create: globalZone];
  [modelSwarm buildObjects];
  [modelSwarm buildActions];
  [modelSwarm activateIn: nil];
  [modelSwarm go];

  exit (EXIT_SUCCESS);
}
