/* 
  ModelSwarm.h

  Barry McMullin <mcmullin@eeng.dcu.ie>
  JAN-1997

*/

#import <simtoolsgui/GUISwarm.h>

#import "Lattice2d.h"
#import "Neighborhood.h"

@interface ModelSwarm: GUISwarm
{
  id modelActions;
  id modelSchedule;

  int numBugs;					  
  int latticeXSize, latticeYSize;
  unsigned rasterScaleFactor;  
  TilingCode tilingCode;
  NeighborhoodCode neighborhoodCode;
  double randomMoveProbability;

  id tipsybugList;
  id lattice;
  unsigned modelTime;
}

- (void)step;
- (void)setStateStopped;
- (void)refreshDisplay;

- (void)setSqrTiling;
- (void)setTriTiling;

- (void)setVNneighborhood;
- (void)setMooreNeighborhood;
- (void)setFHPneighborhood;

@end
