// RuleManager.m                                        

#import "RuleManager.h"

@implementation RuleManager

- createEnd
{
   [super createEnd];

// Tcl interpreter creation
   interp = Tcl_CreateInterp();

// linking C and Tcl variables
   Tcl_LinkVar(interp,"number", (char *) &number,TCL_LINK_INT);
   Tcl_LinkVar(interp,"modifiedNumber1", (char *) &modifiedNumber1,TCL_LINK_INT);
   Tcl_LinkVar(interp,"modifiedNumber2", (char *) &modifiedNumber2,TCL_LINK_DOUBLE);


   return self;
}

- applyRulesToNumber: (int) n;
{
  number=n;

// execute script file
   status=Tcl_EvalFile(interp,"tclTest.tcl");
   resultString=Tcl_GetStringResult(interp);

   if (status != TCL_OK) {printf("Tcl Error:  %s\n",resultString);
                          exit(1);}

   return self;
}

- (int) getModifiedNumber1
{
   return modifiedNumber1;
}

- (double) getModifiedNumber2
{
   return modifiedNumber2;
}

@end

