// ModelSwarm.h					simpleObserverBug2 

#import "Bug.h"
#import "ThinkingBug.h"
#import "FoodSpace.h"

#import <objectbase/Swarm.h>
#import <space.h>
#import <activity.h>
#import <collections.h>
#import <objectbase.h>
#import <simtools.h>

@interface ModelSwarm: Swarm {

  int worldXSize, worldYSize;
  int growthInterval;
  int lifetime;
  int makeThinkingBugs;
  float seedProb;
  float bugDensity;

  id foodSpace;
  id <Grid2d> world;

  id bugList;
  id reaperQueue;
  id modelActions;
  id modelSchedule;
  id growthSchedule;
}

-getWorld;
-getFood;
-getBugList;

+createBegin: (id) aZone;
-createEnd;

-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;

-scheduleGrowthAtX: (int) x Y: (int) y;

-kill: (id) b;
-wipe;
-makeBugsThink;

@end



