// ScheduleDemo (C) Benedikt Stefansson 1998 <benedikt@ucla.edu>
// Version for Swarm 1.4.1 March 26 1999

#import "ObserverSwarm.h"

@implementation ObserverSwarm

+ createBegin: aZone
{
  ObserverSwarm *obj;
  id <ProbeMap> probeMap;

  obj = [super createBegin: aZone];

  // Fill in the relevant parameters (only one, in this case).

  obj->startRed=2;
  obj->startGreen=1;
  obj->startBlue=3;
  obj->zoomFactor=50;

  // Also, build a customized probe map. Without a probe map, the default
  // is to show all variables and messages. Here we choose to
  // customize the appearance of the probe, give a nicer interface.

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  // Add in a bunch of variables, one per simulation parameters

  [probeMap addProbe: [probeLibrary getProbeForVariable: "startRed"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "startGreen"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "startBlue"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "zoomFactor"
                                    inClass: [self class]]];

  
  // Now install our custom probeMap into the probeLibrary.

  [probeLibrary setProbeMap: probeMap For: [self class]];


  return obj;
}

- createEnd
{
 
  return [super createEnd];
}

- buildObjects
{
  [super buildObjects];


  CREATE_PROBE_DISPLAY (self);

  // Instruct the control panel to wait for a button event.
  // We halt here until someone hits a control panel button.

  // Now that we're using Probes, the user can set the parameters
  // in the ModelSwarm probe window - we halt here to allow
  // the user to change parameters.

  [controlPanel setStateStopped];


  colorMap = [Colormap create: self];
  [colorMap setColor: 0 ToName: "grey"];
  [colorMap setColor: 1 ToName: "red"];
  [colorMap setColor: 2 ToName: "green"];
  [colorMap setColor: 3 ToName: "NavyBlue"];
  [colorMap setColor: 4 ToName: "yellow4"];
  // Next, create a 2d window for display, set its size, zoom factor, title.

  // baseRaster=[ZoomRaster create: self];
  baseRaster=[Raster create: self];
  [baseRaster setColormap: colorMap];
  [baseRaster setWidth: 10*zoomFactor
                 Height: 4*zoomFactor];
  [baseRaster setWindowTitle: "Scheduledemo"];
  [baseRaster pack];                             // draw the window.

                    // draw the window.

  
  SET_WINDOW_GEOMETRY_RECORD_NAME(baseRaster);
 
   return self;
}

- buildActions
{

// Create the actions necessary for the simulation. 

  [super buildActions];


  displaySchedule = [Schedule createBegin: self];
  [displaySchedule setRepeatInterval: 1]; // note frequency!
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createActionTo: actionCache message: M(doTkEvents)];
  [displaySchedule at: 0 createActionTo: baseRaster  message: M(drawSelf)];
  
  baseSchedule=[Schedule createBegin: self];
  [baseSchedule setRepeatInterval: 1];
  baseSchedule = [baseSchedule createEnd];
  [baseSchedule at: 0 createActionTo: self message: M(moveBase)];
  
  blueSchedule=[Schedule createBegin: self];
  [blueSchedule setRelativeTime: 1];
  blueSchedule = [blueSchedule createEnd];
  [blueSchedule at: 0 createActionTo: self message: M(moveBlue)];
  [blueSchedule at: 1 createActionTo: self message: M(moveBlue)];
  [blueSchedule at: 2 createActionTo: self message: M(moveBlue)];
  [blueSchedule at: 3 createActionTo: self message: M(moveBlue)];
  
  redSchedule=[Schedule createBegin: self];
  [redSchedule setRepeatInterval: startRed];
  redSchedule = [redSchedule createEnd];
  [redSchedule at: 0 createActionTo: self message: M(moveRed)];

  greenSchedule=[Schedule createBegin: self];
  [greenSchedule setRepeatInterval: 1];
  greenSchedule = [greenSchedule createEnd];
  [greenSchedule at: 0 createActionTo: self message: M(moveGreen)];
 
  
  activateSchedule=[Schedule createBegin: self];
  activateSchedule=[activateSchedule createEnd];
  [activateSchedule at: 0 createActionTo: baseSchedule       message: M(activateIn:): self];
  [activateSchedule at: 0 createActionTo: displaySchedule message: M(activateIn:): self];
  [activateSchedule at: startGreen-1 createActionTo: greenSchedule   message: M(activateIn:): self];
  [activateSchedule at: startRed-1   createActionTo: redSchedule     message: M(activateIn:): self];
  [activateSchedule at: startBlue-1  createActionTo: blueSchedule    message: M(activateIn:): self];
  
  
  return self;
}

- activateIn: swarmContext
{
// activateIn: - activate the schedules so they're ready to run.
  
  [super activateIn: swarmContext];

  // Now activate our schedule in ourselves. This arranges for the
  // execution of the schedule we built.
  [activateSchedule activateIn: self];


  redPos=startRed;
  greenPos=startGreen;
  bluePos=startBlue;
  basePos=0;
  // Activate returns the swarm activity - the thing that's ready to run.

  return [self getSwarmActivity];
}


-moveBase {

  // [baseRaster drawPointX: basePos Y: 0 Color: 0];
  [self drawPointX: basePos Y: 0 Color: 0];
  basePos++;

  return self;
}

-moveRed {


  // [baseRaster drawPointX: redPos Y: 2 Color: 1];
  [self drawPointX: redPos Y: 2 Color: 1];
  redPos+=startRed;
  
  return self;
}


-moveGreen {
  
  // [baseRaster drawPointX: greenPos Y: 3 Color: 2];
  [self drawPointX: greenPos Y: 3 Color: 2];
  greenPos++;

  return self;
}

-moveBlue {
  
  // [baseRaster drawPointX: bluePos Y: 1 Color: 3];
  [self drawPointX: bluePos Y: 1 Color: 3];
  bluePos++;
  
  return self;
}

- drawPointX: (int)x Y: (int)y Color: (Color)c
{
  
  [baseRaster fillRectangleX0: x * zoomFactor Y0: y * zoomFactor
         X1: (x + 1) * zoomFactor Y1: (y + 1) * zoomFactor
         Color: c];

  return self;
}


@end








