// By BenediktStefansson 1997
// Portions (C) Santa Fe Institute

// Object that ranks other objects according to some
// criterion and returns best objects as individuals or lists

#import <objectbase.h>
#import <space.h>
#import <activity.h>
#import <collections.h>

#import <objectbase/Swarm.h>

@class RankedList;
@class RankedData;

@interface RankedList : Swarm {
  int reverseRank;
  id theCollection;
  SEL theSelector;
  id theProbe;
  id theList;
}

-setCollection: (id) c;
-setProbedSelector: (SEL) s;
-setReverseRank;

-createEnd;
-update;

-getBest;
-getList;

@end

@interface RankedData : Swarm {
  double data;
  int reverse;
}

-setData: (double) d;
-setReverse;
-(double) getRankData;
-(int) compare: o;

@end

