#import "Parameters.h"
#import <stdlib.h>
#import <objectbase.h>    //for probeMap
#import <objectbase/ProbeMap.h>

@implementation Parameters

+ createBegin: aZone
 {
   static struct argp_option options[] = {
     {"numppl",'n',"N", 0, "Set numppl", 5},
     {"inputfile", 'I',"filename",0,"set fn",6},
     {"run",'R',"RunNumber",0,"Run is...",7},
     {"seed",'S',"SeedNumber",0,"Seed",8},
     {"vision",'v',"VisionRadius",0,"Vision to radius squares",9},
     { 0 }
   };
 
   Parameters *obj = [super createBegin: aZone];

   [obj addOptions: options];


   obj->numBugs = 100;
   obj->evaporationRate = 0.99;
   obj->diffuseConstant = 1.0;
   obj->worldXSize = 80;
   obj->worldYSize = 80;
   obj->minIdealTemp = 17000;
   obj->maxIdealTemp = 31000;
   obj->minOutputHeat = 3000;
   obj->maxOutputHeat = 10000;
   obj->randomMoveProbability = 0.0;

  // And build a customized probe map. Without a probe map, the default
  // is to show all variables and messages. Here we choose to
  // customize the appearance of the probe, give a nicer interface.
  

 
   return obj;
 }

- init
{
  id <ProbeMap> probeMap;
    probeMap = [EmptyProbeMap createBegin: [self getZone]];
  [probeMap setProbedClass: [self class]];
   probeMap = [probeMap createEnd];

  // Add in a bunch of variables, one per simulation parameter
  if(!probeLibrary) printf("There's no damn probeLibrary");
    [probeMap addProbe: [probeLibrary getProbeForVariable: "numBugs"
  				    inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable: "diffuseConstant"
 				    inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable: "worldXSize"
 				    inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable: "worldYSize"
 				    inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable: "minIdealTemp"
 				    inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable: "maxIdealTemp"
 				    inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable: "minOutputHeat"
 				    inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable: "maxOutputHeat"
 				    inClass: [self class]]]; 
   [probeMap addProbe: [probeLibrary getProbeForVariable: "evaporationRate"
 				    inClass: [self class]]];
   [probeMap addProbe: [probeLibrary getProbeForVariable: "randomMoveProbability"
 				    inClass: [self class]]];

//   // And one method, the "addHeatbug" method for a probe demo.
//   // we also hide the return value for this message probe, just for nicety.

//    [probeMap addProbe: [[probeLibrary getProbeForMessage: "addHeatbug:"
//  			     inClass: [self class]]
//  			setHideResult: 1]];

//   // Now install our custom probeMap into the probeLibrary.

     [probeLibrary setProbeMap: probeMap For: [self class]];
     return self;

}


- (int)parseKey: (int) key arg: (const char*) arg
 {
   if (key == 'n')
     {
       numpplArg = arg;
       return 0;
     }
   if (key == 'v')
     {
       visionRadiusArg = arg;
       return 0;
     }
   if (key == 'S')
     {
       seedArg = arg;
       return 0;
     }
   if (key == 'I')
     {
       printf("here is an I \n");
       return 0;
     }
   if (key == 'R')
     {
       runArg = arg;
       return 0;
     }
   else
     return [super parseKey: key arg: arg];
 }

- (int) getNumpplArg
 {
   int num=-1;
   if(numpplArg)
   num = atoi(numpplArg); 
   return num;
 }

- (int) getVisionRadiusArg
{
  int num=-1;
  if(visionRadiusArg)
    num = atoi (visionRadiusArg);
  return num;
}

- (int) getRunArg
{
  int num=-1;
  if(runArg)
    num = atoi (runArg);
  return num;
}

- (int) getSeedArg
{
  int num = -1;
    if(seedArg)
    num = atoi (seedArg);
  return num;
}

-sayHello
{

    printf("You are a dirty scoundrel");
    return self;
}


-(int)getNumBugs{return numBugs;}
-(double)getEvaporationRate {return evaporationRate;}
-(double)getDiffuseConstant { return diffuseConstant;}
-(int)getWorldXSize { return worldXSize;}
-(int)getWorldYSize { return worldYSize;}
-(int)getMinIdealTemp { return minIdealTemp;}
-(int)getMaxIdealTemp { return maxIdealTemp;}
-(int)getMaxOutputHeat { return maxOutputHeat;}
-(int)getMinOutputHeat {return minOutputHeat;}
-(double) getRandomMoveProbability { return randomMoveProbability;}




@end
