 

//Ppoint.m       potential     by Artan Simeqi

#import "Ppoint.h"
#import "Charge.h"
#import <collections.h>

@implementation Ppoint

-setWorld: (id) w {
world = w;
return self;
}

-setArrayOfCharges: (id) c Count: (int) count1{
arrayOfCharges = c;
count=count1;
return self;
}

-createEnd {
[super createEnd];
worldXSize= [world getSizeX];
worldYSize= [world getSizeY];
return self;
}

-setX: (int) x Y: (int) y {
xPos = x;
yPos = y;
return self;
}


-setPotential{

// Nothing special here. The potential is calculated as the sum
// of all the contributions that come from all the charges.

double sum;
int i;
sum=0;

for(i = 0; i < count; i++)  {
sum = sum + [[arrayOfCharges atOffset: i] getContributionAtX: xPos Y: yPos];

}
potential=sum;

return self;
}

- (double) getPotential {
return potential;
}
-drawSelfOn: (Raster *) r {
[r drawPointX: xPos Y: yPos Color: color];
return self;
}

-setColorMinPot:  (double) minPot 
         DifPot: (double) difPot 
         NumColors: (int) numColors {


rcol = (potential-minPot)*numColors/difPot;
color=0;
while (color<rcol)
color=color+1;
color=color+2;
if (color<3)  //Normally it should never happen that color be <3 or
		// >2+numColors.
color = 3;    //But in some rare cases, it happens. You may try the program
if (color> (2+numColors)) //without these four lines.
color= 2+numColors;
return self;
}
@end



