// ModelSwarm.m       potential   by Artan Simeqi 

#import "ModelSwarm.h"

@implementation ModelSwarm  

// These methods provide access to the objects inside the ModelSwarm.
// These objects are the ones visible to other classes via message call.
// In theory we could just let other objects use Probes to read our state,
// but message access is frequently more convenient.


-getWorld {
  return world;
}

-getArrayOfPoints {
	return arrayOfPoints;
}

-getArrayOfCharges {
	return arrayOfCharges;
}

+createBegin: (id) aZone {
  ModelSwarm * obj;
  ProbeMap * probeMap;

  // in createBegin, we set up the simulation parameters

  // First, call our superclass createBegin - the return value is the
  // allocated BugSwarm object.

  obj = [super createBegin: aZone];

  // Now fill in various simulation parameters with default values.

  obj->worldXSize = 160;
  obj->worldYSize = 160;
  obj->numColors = 8;	
  obj->chargesFraction = 10;  //For each 10 points we have a charge

  // And build a customized probe map. Without a probe map, the default
  // is to show all variables and messages. Here we choose to
  // customize the appearance of the probe, give a nicer interface.

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  // Add in a bunch of variables, one per simulation parameter

  [probeMap addProbe: [probeLibrary getProbeForVariable: "worldXSize"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "worldYSize"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "numColors"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "minPotential"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "maxPotential"
				    inClass: [self class]]];

  // Now install our custom probeMap into the probeLibrary.

  [probeLibrary setProbeMap: probeMap For: [self class]];
  
  // We've created the BugSwarm and initialized it.
  // return the id of the newly created Swarm

  return obj;
}

-createEnd {
  return [super createEnd];
}



-buildObjects {
  Charge * aCharge;
  Ppoint * aPoint;
  int x,y,i,j;
  int numXCharges;

  // Here, we create the objects in the model

  

  // Now set up the grid used to represent charge or point  position
  // Grid2d enforces only 1 object  per site

  world = [Grid2d createBegin: [self getZone]];
  [world setSizeX: worldXSize Y: worldYSize];
  world = [world createEnd];
  [world fillWithObject: nil];

	
 
  // Now, create an array of charges and another for all the points 
  // where the potential is being calculated.

  numXCharges=worldXSize/chargesFraction;
  arrayOfCharges=[Array create: [self getZone] setCount: (int)((worldXSize)*(worldYSize)/chargesFraction/chargesFraction) ];
   for (y = 5,j=0; y < worldYSize; y+=chargesFraction,j++){
    for (x = 5,i=0; x < worldXSize; x+=chargesFraction,i++){

	aCharge = [Charge createBegin: [self getZone]];
	[aCharge setWorld: world];
	aCharge = [aCharge createEnd];
	[aCharge setX: x Y: y];
	[aCharge setCharge: 0 Sign: 0];
	[world putObject: aCharge atX: x Y: y];
        [arrayOfCharges atOffset: (j*numXCharges + i) put: aCharge];
	}
      }

  arrayOfPoints=[Array create: [self getZone] setCount:(worldXSize*worldYSize) ];
   for (y = 0; y < worldYSize; y++){
    for (x = 0; x < worldXSize; x++){

	aPoint = [Ppoint createBegin: [self getZone]];
	[aPoint setWorld: world];
	
	aPoint = [aPoint createEnd];
	[aPoint setX: x Y: y];
	if ([world getObjectAtX: x Y: y] == nil) 
	[world putObject: aPoint atX: x Y: y];            
        [arrayOfPoints atOffset: (y*worldXSize + x) put: aPoint];
	 }
      }
 



  return self;
}

-buildActions {

  // Create the list of simulation actions. We put these in an action
  // group, because we want these actions to be executed in a specific
  // order, but these steps should take no (simulated) time. The
  // M(foo) means "The message called <foo>". You can send a message
  // To a particular object, or ForEach object in a collection.

  modelActions = [ActionGroup create: [self getZone]];
  
  [modelActions createActionTo: self message: M(createRealChargesArray)];
  [modelActions createActionTo: self message: M(setArrayOfCharges)];
  [modelActions createActionForEach: arrayOfPoints    message: M(setPotential)];
  [modelActions createActionTo: self message: M(findMinMaxPotentials)];
  [modelActions createActionTo: self message: M(setColors)];


  // Then we create a schedule that executes the modelActions. modelActions
  // is an ActionGroup, by itself it has no notion of time. In order to
  // have it executed in time, we create a Schedule that says to use
  // the modelActions ActionGroup at particular times.
  // This schedule has a repeat interval of 1, it will loop every time step.
  // The action is executed at time 0 relative to the beginning of the loop.

  

  modelSchedule = [Schedule createBegin: [self getZone]];
  [modelSchedule setRepeatInterval: 1];
  modelSchedule = [modelSchedule createEnd];
  [modelSchedule at: 0 createAction: modelActions]; 

  return self;

}

-activateIn: (id) swarmContext {

  // Here, we activate the swarm in the context passed in
  // Then we activate our schedule in ourselves

  [super activateIn: swarmContext];

  [modelSchedule activateIn: self];

  return [self getSwarmActivity];

}

-findMinMaxPotentials {

//Here I find the minimal and maximal values of potentials all over the
//field.

double pot;
int y,x;
minPotential=1e+20;
maxPotential=-1e+20;

 for (y = 0; y < worldYSize; y++){
    for (x = 0; x < worldXSize; x++){
	pot = [[arrayOfPoints atOffset: (y*worldXSize+x)] getPotential];
	if (pot<minPotential)
	minPotential=pot;
	if (pot>maxPotential)
	maxPotential=pot;
	}
      }
return self;
}

-setColors { 

//What I do here, is only a call to the setColor message of Ppoint for each
//point

int y,x;
double dif;
dif=maxPotential-minPotential;
for (y = 0; y < worldYSize; y++){
    for (x = 0; x < worldXSize; x++){
	[[arrayOfPoints atOffset: (y*worldXSize+x)] setColorMinPot: minPotential DifPot: dif NumColors: numColors];
}
}
return self;
}



-createRealChargesArray {

//Find all the Charge objects that have charge different from 0
//and then put them on realChargesArray.
 
int i, j, count;
double charge;

count1 = 0;
count =[arrayOfCharges getCount];
for(i = 0; i < count; i++) {
charge=[[arrayOfCharges atOffset: i] getCharge];
if (charge != 0)
count1 = count1 + 1;
}
 realChargesArray=[Array create: [self getZone] setCount: (count1+1) ];

j=0;
for(i=0; i<count; i++) {
charge=[[arrayOfCharges atOffset: i] getCharge];
if (charge != 0) {
[realChargesArray atOffset: j put: [arrayOfCharges atOffset: i]];

j = j+1;
}
}

return self;
}

-setArrayOfCharges {

//Inform the points where is the array of Charges with charge != 0

int y,x;

for (y = 0; y < worldYSize; y++){
    for (x = 0; x < worldXSize; x++){
	[[arrayOfPoints atOffset: (y*worldXSize+x)] setArrayOfCharges: realChargesArray  Count: count1];
}
}
return self;
}

-dropRealChargesArray {

// I don't know if this is really needed. Here I don't use it.
// When I try to use it, it causes a bug. In fact in that case 
// the program will shut down any time you try to have a probe
// in a point other than a charge.

 [realChargesArray drop];

return self;
}

@end















