// Camera.h

// Copyright (C) 1996 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

#import "Intrinsic.h"
#import "Extrinsic.h"
#import <objectbase/SwarmObject.h>

@interface Camera: SwarmObject
{
  Intrinsic *Intr;
  Extrinsic *Extr;
  char name[100];
}

// initialize
- initCamera: (char *)identifier;

// send parameters
- sendIntr;
- sendExtr;
- (char *)sendName;

// print name
- print;

// compute a list of imaged objects from a list of 3D objects
- (int)ComputeImage: point
                   : list
                   : (int)numOfObj
                   : (int)YSizeOfSwarmGrid;

@end
