// file: main.m
// the infamous village formation model
// 1996 the Swarm room - Eric

// village specific headers
#import "village.h"
#import "AgentObserverSwarm.h"

// The main() function is the top-level place where everything starts.
// For a typical Swarm simulation, in main() you create a toplevel
// Swarm, let it build and activate, and set it to running.

int
main (int argc, const char **argv)
{
  AgentObserverSwarm *observerSwarm;
  //  AgentBatchSwarm *batchSwarm;

  // Swarm initialization: all Swarm apps must call this first.
  initSwarm (argc, argv);
  //[randomGenerator initSeed: 12345];

  // swarmGUIMode is set in initSwarm(). It's set to be 1 if your
  // DISPLAY environment variable is set (ie, you have an X server to
  // do graphics with). Otherwise, it's set to 0.
  
  if (swarmGUIMode == 1) {
    // We've got graphics, so make a full ObserverSwarm to get GUI objects
    observerSwarm = [AgentObserverSwarm createBegin: globalZone];
    SET_WINDOW_GEOMETRY_RECORD_NAME (observerSwarm);
    observerSwarm = [observerSwarm createEnd];

    [observerSwarm buildObjects];
    [observerSwarm buildActions];
    [observerSwarm activateIn: nil];
    [observerSwarm go];
  } else {
    fprintf(stderr,"ERROR: village batchmode has not been implemented as of yet.\n");
    fprintf(stderr,"  setenv DISPLAY home_machine:0.0 will enable X-win display\n");
    // No graphics - make a batchmode swarm and run it.
    // batchSwarm = [HeatbugBatchSwarm create: globalZone];
    // [batchSwarm buildObjects];
    // [batchSwarm buildActions];
    // [batchSwarm activateIn: nil];
    // [batchSwarm go];
  }

  // The toplevel swarm has finished processing, so it's time to quit.
  return 0;
}
