// file: Agent.h
// 08-16-95 the Swarm room
// variables and methods of agent class

#import <objectbase.h>
#import <collections.h>
#import <simtools.h>
#import <space.h>
#import <gui.h>

#import "village.h"
#import "Exchange.h"
#import "Cell.h"
#import "AgentModelSwarm.h"


@interface Agent: SwarmObject
{
  int   tag;					  // agent id tag
  int   x, y;					  // agent spatial coordinates
  int   worldX;					  // how big world is for X
  int   worldY;					  // and Y
  id <Grid2d> world;				  // pointer to agents world
  id    mySwarm;
  id    cell[9];				  // cells near agent position
  
  Color myColor;					  // display colors

  // internal household attributes
  int   agent_time;				  // global time
  int   form_date;				  // date of formation
  int   family_tag;				  // call it clan
  int   ages[10];				  // array of ages
  int   num_family;				  // total
  int   num_kids;				  // num kids

  // food and planting info
  int   maize_storage;				  // food stock
  int   farm_pl[9];				  // # ha for farming
  int   tot_plots;				  // how many planted
  int   plot_need;				  // plots desired left
  int   max_store;				  // max limit storage
  
  // trading stuff
  id traders;					  // keeps trading info

  // expectations of farming productivity and Cal needs
  int   agentState;
  int   EXP_cal_need;
  int   AVG_cal_prod;
  int   EXP_yield;
  int   act_yield;
  int   past_yield[9][3];			  // record of local yields
  int   actual_cal;				  // spent in each season
  int   total_cal;				  // yearly figure
}

// creation stuff
+ createBegin: aZone;

// agent creation
- setTag: (int)tag;
- setFormationDate: (int)date;
- setMySwarm: s;
- setWorld: (id <Grid2d>)world;
- setX: (int)x Y: (int)y;
- setParentAges: (int)i and: (int)j;
- setRandNumKids: (int)num;
- createEnd;

// set agent internal state
- setCells;
- setFamilyTag: (int)tag;
- setMaizeStorage: (int)food;
- setFarmPl: (int)plots At: (int)i;

// the major actions
- step;

// the seasons
- spring;
- summer;
- fall;
- winter;

// family yearly stuff
- updateFamily;
- birth: (int)motherage;
- (int)mortality: (int)age;
- death;
- addPerson: (int)age;
- removePerson: (int)age;
- evalState;

// family eating and farming
- eatMaize: (int)cals;
- (int)calcExpCalUse;
- (int)calcFarmPl;
- plantPl: (int *)plots At: (int)i;
- unplotDX: (int *)x DY: (int *)y;
- unPlotAll;
- updateYields;

// new households, movement, and search
- moveHouse;
- addHousehold;
- searchNeighborhoodDX: (int *)x DY: (int *)y Rad: (int)radius;
- (int)evalCellX: (int)inx Y: (int)iny Max: (int)max;

// get agent internal state
- (int)getFamilySize;
- (int)getTag;
- (int)getFamilyTag;
- (int)getFormationDate;
- (int)getNumPlots;
- (int)getMaizeStorage;
- (int)getFarmPlAt: (int) i;
- (int)getYield;
- (int)getAgentState;
- (int)getMaxStore;

// extra display code, to be removed
- setColor: (Color)c;
- drawSelfOn: (id <Raster>)r;

// debugging, print agent info
- debug: (int) number;
- test;

@end

