// Copyright (C) 1995 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.


#import <collections.h>

#import "BinChrom.h"
#import "PopSwarm.h"

#include <stdlib.h>		// for atof

#define STRSIZE 20

@implementation PopulationSwarm


// Comparison function
int compFunc( id a, id b ) {

    float tmp1, tmp2;
    
    sscanf( (char*) a, "%f", &tmp1 );
    sscanf( (char*) b, "%f", &tmp2 );
//    printf( "Comparando %s %s %f %f\n", (char*) a,(char*) b , tmp1, tmp2 );

    if ( tmp1 > tmp2 ) 
	return -1;
    else
	return 1;
}

// ------------------------------ Swarm functions --------------

+createBegin: (id) aZone {

  PopulationSwarm *obj;
  ProbeMap * probeMap;

  obj = [super createBegin:aZone];

  // init defaults
  obj->popSize = 100;
  obj->chromLen = 0;
  obj->mating = 0.01;
  obj->mut = 0.05;
  obj->dup = 0;
  obj->kill = 0;
  obj->swap = 0;
  obj->remrei = 0;		// Probabilities of application of genOps
  obj->generations = 100;	// Generations to run
  obj->evalFunc = 0;		// Evaluation function

  // Create probes
  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  // MODIFY: add your own probes for your parameters.
  [probeMap addProbe: [probeLibrary getProbeForVariable: "popSize"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "generations"
				     inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "mating"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "mut"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "dup"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "kill"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "remrei"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "evalFunc"
				    inClass: [self class]]];
  
  [probeLibrary setProbeMap: probeMap For: [self class]];
  
  return obj;
}

-setChromLength: (unsigned) _len {
  chromLen = _len;
  return self;
}

-setEvaluationFunc: (float(*)( id )) _evalFunc {
  evalFunc = _evalFunc;
  return self;
}

// __________________________
// Build simulation objects
-buildObjects {
  unsigned i;

  [super buildObjects];
  newPopList = [List create: zone];

  // Create initial random population
  for ( i = 0; i < popSize; i++ ) {
    BinChromosome* gen;
    gen = [BinChromosome createBegin: zone];
    [[gen setLength: chromLen] setRandomInit];
    gen = [gen createEnd];
    
    [newPopList addFirst: gen];
  }
   
  // Create intial map, to keep evaluated genes
  popList = [Map createBegin: zone];
  [popList setCompareFunction: compFunc];
  popList = [popList createEnd];

  return self;
}

-buildActions {
  [super buildActions];

  // MODIFY: schedule your own agents as appropriate.
  modelActions = [ActionGroup create: [self getZone]];
  [modelActions createActionTo: self message: M(evaluate)];
  [modelActions createActionTo: self message: M(newGeneration)];

  modelSchedule = [Schedule createBegin: [self getZone]];
  [modelSchedule setRepeatInterval: 1];
  modelSchedule = [modelSchedule createEnd];
  [modelSchedule at: 0 createAction: modelActions];
  
  return self;
}
//_______________________________________________________________
-activateIn: (id) swarmContext  {
//_______________________________________________________________
  [super activateIn: swarmContext];

  [modelSchedule activateIn: self];

  return [self getSwarmActivity];
}

//_______________________________________________________________
-createEnd {
//_______________________________________________________________
  
  return [super createEnd];
}

// From protocol
//_______________________________________________________________
-evaluate {			// Evaluates all member of the population
//_______________________________________________________________

    // Takes them from the new list and places then in the Population map,
    // keyed with fitness

    id index, member;
    index = [newPopList begin: zone];
    //    printf ( "Evaluating \n");
    while ( ( member = [index next]) ) {
	float result =  ((*evalFunc)( member )) ;
	char* strres = (char*) calloc( STRSIZE, sizeof(char)); 
	[member setFitness: result];
	sprintf( strres, "%f", result );
//	printf( "\nAsignando %s ", strres);
	if (! [popList at: (id) strres insert: member ] ) {
	    [SourceMessage raiseEvent : "Something is wrong\n" ];
	}
//	free( strres );
    }
    [index drop];

    // now remove all members of the list
    index = [newPopList begin: zone];
    while ( ( member = [index next]) ) {
	[index remove];
    }
    [index drop];

/*    index = [population begin: zone];
    while ( ( member = [index next]) ) {
	printf( "Miembro %s con clave %s\n", [member getGenotype], (char* )[index getKey] );
    }
    [index dropFrom: zone];
*/
    return self;
}

-(unsigned) getGenerationCount {
  return generationCount;
}

-(unsigned) getGenerations {
  return generations;
}

-newGeneration {

    id index, stiff;
    unsigned killQuant = popSize*( mating + mut + dup + kill +swap + remrei), 
	i;

    // Increase generation Count
    generationCount++;

    // Kill the worst mutProb, and substitute them by the siblings of the
    // others
    i = 0; 
    index = [ popList begin: zone];
    [index setLoc: End];

    while( ( i < killQuant) && (stiff = [index prev] ) ){
	[stiff free];		// Eliminate gen
	[index remove];
	i++;
    }
    [index drop];

    // Now make the new ones as siblings from the first kill percent
    // and another randomly chosen
    for ( i = 0; i < popSize*mating; i ++ ) {
	BinChromosome* gen;
	gen = [BinChromosome createBegin: zone];
	[gen Mate: [popList atOffset:[uniformRandom rMax:[popList count]]]
	     And: [popList atOffset:[uniformRandom rMax:[popList count]]]
	     withMutation: mut];
	if ( ! (gen = [gen createEnd] ) ) {
	     [SourceMessage raiseEvent: "Error creating chromosome\n"];
	     return nil;
	}
	[newPopList addFirst: gen];
    }

     for ( i = 0; i < popSize*mut; i ++ ) {
	BinChromosome* gen;
	gen = [BinChromosome createBegin: zone];
	[gen Clone:
		 [popList atOffset:[uniformRandom rMax:[popList count]]]
	     withMutation: mut];
	if ( ! (gen = [gen createEnd] ) ) {
	     [InvalidCombination raiseEvent: "Error creating chromosome"];
	}
	[newPopList addFirst: gen];
    }

     for ( i = 0; i < popSize*dup; i ++ ) {
	BinChromosome *gen, *chosenGen;
	unsigned gene;
	chosenGen = 
	    [popList atOffset:[uniformRandom rMax:[popList count]]];
	gene = [uniformRandom rMax: [chosenGen getLength]];
	gen = [BinChromosome createBegin: zone];
	[gen Duplicate: chosenGen From: gene To: gene withMutation: mut];
	if ( ! (gen = [gen createEnd] ) ) {
	     [InvalidCombination raiseEvent:"Error creating chromosome\n"];
	}
	[newPopList addFirst: gen];
     } 

     for ( i = 0; i < popSize*swap; i ++ ) {
	BinChromosome *gen, *chosenGen;
	unsigned gene1, gene2;
	chosenGen = 
	    [popList atOffset:[uniformRandom rMax:[popList count]]];
	gene1 = [uniformRandom rMax: [chosenGen getLength]];
	gene2 = [uniformRandom rMin: gene1 Max: [chosenGen getLength]];

	gen = [BinChromosome createBegin: zone];
	[gen Swap: chosenGen : gene1 with: gene2 size: 1];
	if ( ! (gen = [gen createEnd] ) ) {
	     [InvalidCombination raiseEvent: "Error creating chromosome\n"];
	}
     } 

     for ( i = 0; i < popSize*remrei; i ++ ) {
	BinChromosome *gen, *chosenGen;
	unsigned gene1, gene2;
	chosenGen = 
	    [popList atOffset:[uniformRandom rMax:[popList count]]];
	gene1 = [uniformRandom rMax: [chosenGen getLength]];
	gene2 = [uniformRandom rMin: gene1 Max: [chosenGen getLength]];

	gen = [BinChromosome createBegin: zone];
	[gen RemoveReinsert: chosenGen : gene1 To: gene2 size: 1];
	if ( ! (gen = [gen createEnd] ) ) {
	     fprintf( stderr, "Error creating chromosome\n");
	     return nil;
	}
	[newPopList addFirst: gen];
    } 
    return self;
}

-getBest{			// Returns the best genome
//    printf( "Total %d\n", [population count]);
//    id index = [population begin: zone], member = [index next];// First member
//    printf( "Miembro %s con clave %s\n", [member getGenotype], (char* )[index getKey] );
//    [index dropFrom: zone];
    return [popList first];
}


-(double) getBestFitness{		// Fitness of the best genome
    float tmp;
    id index = [popList begin: zone];// First member
    char key[STRSIZE];
    [index next];
    strcpy( key, (char * ) [index getKey] );
    [index drop];
    sscanf( key, "%f", &tmp );
    return tmp;
}

-(id) getList {
  return popList;
}
@end

