// -*- mode: objc; -*-
// Copyright (C) 1995 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

#ifndef _SSPOP_H
#define _SSPOP_H

#import <swarmobject.h>

#import "Population.h"		// Population protocol

@interface PopulationSwarm: Swarm <Population> { // Steady state population
  // Simulation parameters
  unsigned popSize;
  float mating, mut, 
  dup, kill, swap,
  remrei;			// Probabilities of application of genOps
  unsigned generations,
    generationCount;		// Generations to run

  unsigned chromLen;
  float (*evalFunc) (id<Chromosome>); // Evaluation Function

  id modelActions;
  id modelSchedule;		// Scheduling data structures

  // Population variables
  id popList, newPopList;	// Will be a collection

} 



// Compulsory methods
+createBegin: (id) aZone;
-createEnd;
-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;

// Other methods
-setChromLength: (unsigned) _len;
-setEvaluationFunc: (float(*)( id )) _evalFunc;

@end

#endif
