/* 
  SCLModelSwarm.m

  Barry McMullin <mcmullin@eeng.dcu.ie>
  30-SEP-1996

*/

#import <simtools.h>

#import "SCLGlobals.h"

#import "PRNG.h"

#import "VNneighbor.h"
#import "MooreNeighbor.h"
#import "SCLDisplay.h"
#import "AgentManager.h"
#import "ParticleManager.h"
#import "ParameterManager.h"
#import "WorldManager.h"
#import "UserCellEditor.h"

#import "Hole.h"
#import "Substrate.h"
#import "Link.h"
#import "Catalyst.h"
#import "Bond.h"

#import "SCLModelSwarm.h"

@implementation SCLModelSwarm


-buildObjects 
{
  [super buildObjects];

  worldManager = [WorldManager create: self];
  parameterManager = [ParameterManager create: self];

  CREATE_ARCHIVED_PROBE_DISPLAY (worldManager);
  CREATE_ARCHIVED_PROBE_DISPLAY (parameterManager);

  prng = [PRNG create: self]; 
  [prng setPRNGstate: 42];   // What else?

  vnNeighbor = [VNneighbor create: self];
  mooreNeighbor = [MooreNeighbor create: self];
  defaultNeighbor = mooreNeighbor;

  /* We build the colormap, and assign (default) colors to
     classes etc. here; it must be done before any agents are
     created, and before the user gets a change to override
     the defaults... */

  colormap = [Colormap create: self];

  [colormap setColor: 0 ToName: "white"];
  [worldManager setBackgroundColor: 0];
  [Hole setClassColor: 0];

  [colormap setColor: 1 ToName: "red"];
  [Substrate setClassColor: 1];

  [colormap setColor: 2 ToName: "LimeGreen"];
  [Catalyst setClassColor: 2];

  [colormap setColor: 3 ToName: "blue"];
  [Bond setClassColor: 3];
  [Link setClassColor: 3];

  [colormap setColor: 4 ToName: "SkyBlue"];
  [Link setAbsorbedSubstrateColor: 1];

  [colormap setColor: 5 ToName: "SteelBlue"];
  [Link setDisintegratingColor: 5];

  [colormap setColor: 6 ToName: "cyan"];
  [colormap setColor: 7 ToName: "black"];
  
  return self;
}


/*
-initialDisplay{
  [worldManager refreshDisplay];
  [controlPanel setStateStopped];

  return self;
}
*/

#ifdef ROOT_SCREENSHOTS
- _takeSnapshotOfRoot
{
  char filename[40];

  // Create a file name that contains the simulation time:
  sprintf(filename,"zmovie.rootwindow.%04d.png", getCurrentTime());

  // Write the bitmap snapshot to disk:
  [[ [[[Pixmap createBegin: self] 
        setWidget: nil] // ('nil'=>root window)
                        createEnd] 
     save: filename] drop];
  
  return self;
}
#endif

#ifdef RASTER_SCREENSHOTS
- _takeSnapshotOfRaster
{
  char filename[40];
  
  sprintf (filename, "zmovie.raster%07d.png", getCurrentTime());
  [[[[[[Pixmap createBegin: self]
        setWidget: worldRaster]
       setDecorationsFlag: YES]
      createEnd] save: filename] drop];
}
#endif

-step 
{

#ifdef ROOT_SCREENSHOTS
  [self _takeSnapshotOfRoot];
#endif
#ifdef RASTER_SCREENSHOTS
  [self _takeSnapshotOfRaster];
#endif
  [actionCache doTkEvents];
  [parameterManager step];
  [worldManager step];

  return self;
}

-buildActions {
  [super buildActions];
  
  modelActions = [ActionGroup create: self];

  [modelActions createActionTo: self message: M(step)];

  modelSchedule = [Schedule createBegin: self];
  [modelSchedule setRepeatInterval: 1];
  modelSchedule = [modelSchedule createEnd];
  [modelSchedule at: 0 createAction: modelActions];

  return self;
}

- activateIn:  swarmContext 
{
  [super activateIn: swarmContext];

  [modelSchedule activateIn: self];

  return [self getActivity];
}


-setStateStopped {
  /* 
    I don't simply use [controlPanel setStateStopped]
    because if we are already stopped that forces a wait
    for a click on some control panel button other than
    stop ... *not* what I want!
  */

  //  if (getTopLevelActivity()) 
  //  [getTopLevelActivity() stop]; 

  if ([controlPanel getState] != ControlStateStopped)
    [controlPanel setStateStopped];

  //  [controlPanel setState: ControlStateStopped];

  return self;
}


@end
