/* 
  UserCellEditor.m

  Barry McMullin <mcmullin@eeng.dcu.ie>
  23-OCT-1996

*/

#import <simtoolsgui.h>

#import "UserCellEditor.h"

@implementation UserCellEditor

-createEnd {
  UserCellEditor *finalSelf;
  id <ProbeMap> probeMap;

  finalSelf = [super createEnd];

  probeMap = [EmptyProbeMap createBegin: [finalSelf getZone]];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: 
    [probeLibrary getProbeForVariable: "worldX"
       inClass: [finalSelf superClass]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForVariable: "worldY"
       inClass: [finalSelf superClass]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForVariable: "agent"
       inClass: [finalSelf superClass]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForMessage: "forceCatalyst"
       inClass: [finalSelf superClass]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForMessage: "forceLink"
       inClass: [finalSelf superClass]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForMessage: "forceSubstrate"
       inClass: [finalSelf superClass]]];
  [probeMap addProbe: 
    [probeLibrary getProbeForMessage: "forceHole"
       inClass: [finalSelf superClass]]];

  [probeLibrary setProbeMap: probeMap For: [finalSelf class]];

  [probeDisplayManager createProbeDisplayFor: finalSelf];

  return (finalSelf);
}

-update {
  [super update];
  [probeDisplayManager update];

  return self;
}
   

@end
