// Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/* 
  DiscreteToroid.h

  Subclass of Discrete2d with some built in support for toroidal
  geometry. The -wrapXCoord and-wrapYCoord methods provide
  for explicitly wrapping arbitrary coordinate values to
  suit the space; this class also overrides the -getObjectAtX:Y:
  and -putObject:AtX:Y: methods so that the provided coordinates
  are first wrapped (to be sure to be sure (;-).

  Barry McMullin <mcmullin@eeng.dcu.ie>
  26-SEP-1996
*/

#import <space/Discrete2d.h>

@interface DiscreteToroid: Discrete2d 

-(int) wrapXCoord: (int) inX;
-(int) wrapYCoord: (int) inY;

@end

