/* 
  CellEditor.m

  Barry McMullin <mcmullin@eeng.dcu.ie>
  07-OCT-1996

*/

#import <simtools.h>

#import "SCLGlobals.h"
#import "SCLModelSwarm.h"

#import "AgentManager.h"

#import "Hole.h"
#import "Substrate.h"
#import "Link.h"
#import "Catalyst.h"

#import "CellEditor.h"

@implementation CellEditor

-createEnd {
  CellEditor *finalSelf;

  finalSelf = [super createEnd];
  [finalSelf setWorldX: ([world getSizeX]/2) Y: ([world getSizeY]/2)];

  return (finalSelf);
}

-update {
  agent = [world getObjectAtX: worldX Y: worldY];
  if (agent == nil)
    agentClass = nil;
  else
    agentClass = [agent class];

  return self;
}

-setRasterX: (int) newX Y: (int) newY {
  rasterX = newX;
  rasterY = newY;

  worldX = rasterX/8;
  worldY = rasterY/8;

  [self update];

  return self;
}

-setWorldX: (int) newX Y: (int) newY {
  worldX = [world wrapXCoord: newX];
  worldY = [world wrapYCoord: newY];

  rasterX = worldX * 8;
  rasterY = worldY * 8;

  [self update];

  return self;
}

-forceCatalyst {
  Catalyst *catalyst;

  if (agentClass != [Catalyst class]) {
    [worldManager dropAgent: agent];
    catalyst = [catalystMgr createAgent];
    [catalyst unwarpToX: worldX Y: worldY];
    [self update];
    [worldManager update];
  }

  return self;
}
    
-forceLink {
  Link *link;

  if (agentClass != [Link class]) {
    [worldManager dropAgent: agent];
    link = [linkMgr createAgent];
    [link unwarpToX: worldX Y: worldY];
    [self update];
    [worldManager update];
  }

  return self;
}

-forceSubstrate {
  Substrate *substrate;

  if (agentClass != [Substrate class]) {
    [worldManager dropAgent: agent];
    substrate = [substrateMgr createAgent];
    [substrate unwarpToX: worldX Y: worldY];
    [self update];
    [worldManager update];
  }

  return self;
}
 

-forceHole {
  Hole *hole;

  if (agentClass != [Hole class]) {
    [worldManager dropAgent: agent];
    hole = [holeMgr createAgent];
    [hole unwarpToX: worldX Y: worldY];
    [self update];
    [worldManager update];
  }

  return self;
}
     

@end
