/* 
  Catalyst.m

  Barry McMullin <mcmullin@eeng.dcu.ie>
  30-SEP-1996

*/

#import <simtools.h>

#import "SCLGlobals.h"
#import "SCLModelSwarm.h"

#import "AgentManager.h"
#import "PRNG.h"

#import "Hole.h"
#import "Substrate.h"
#import "Link.h"
#import "Catalyst.h"

@implementation Catalyst


static double catalystMobilityFactor = 0.0;
static Color catalystColor = 4;
/*
  See docs in Particle.m
*/

+(void) setClassMobilityFactor: (double) inMobilityFactor {
  catalystMobilityFactor = inMobilityFactor;
}

+(double) getClassMobilityFactor {
  return(catalystMobilityFactor);
}

+(void) setClassColor: (Color) color {
  catalystColor = color;
}

+(Color) getClassColor {
  return(catalystColor);
}

static double productionProbability = 1.0;

+(void) setProductionProbability: (double) inProductionProbability {
  productionProbability = inProductionProbability;
}

+(double) getProductionProbability {
  return(productionProbability);
}

-doProduction {
  neighbor_t neighbor0, neighbor1;
  Particle *neighborParticle0, *neighborParticle1;
  Hole *hole;
  int holeX, holeY;
  Link *link;
  int linkX, linkY;

  if ([prng getTossWithProb: productionProbability]) {
    neighbor0 = [defaultNeighbor getRandom];
    neighborParticle0 = [self getAgentAtNeighbor: neighbor0];
    if (neighborParticle0 == nil) 
      [InternalError raiseEvent:
	 "nil encountered at neighbor %d of particle %d.\n",
	 neighbor0, self];
    else {
      if ([neighborParticle0 isMemberOf: [Substrate class]]) {
	if ([prng getTossWithProb: 0.5])
	  neighbor1 = [defaultNeighbor getNext: neighbor0]; 
	else
	  neighbor1 = [defaultNeighbor getPrevious: neighbor0];

	neighborParticle1 = [self getAgentAtNeighbor: neighbor1];
        if (neighborParticle1 == nil)
	  [InternalError raiseEvent:
	     "nil encountered at neighbor %d of particle %d.\n",
	     neighbor1, self];
        else {
	  if ([neighborParticle1 isMemberOf: [Substrate class]]) {
	  // OK, we got two reactants - do it!

          holeX = [neighborParticle0 getX];
          holeY = [neighborParticle0 getY];
	  [substrateMgr dropAgent: neighborParticle0];
	  hole = [holeMgr createAgent];
	  [hole unwarpToX: holeX Y: holeY];

	  linkX = [neighborParticle1 getX];
	  linkY = [neighborParticle1 getY];
	  [substrateMgr dropAgent: neighborParticle1];

	  link = [linkMgr createAgent];
	  [link unwarpToX: linkX Y: linkY];
	  }
	}
      }
    }
  }

  return self;
}

-step {
  [self doMotion];
  [self doProduction];  

  return self;
}

-drawSelfOn: (id <Raster>) r {
  /* 
    Default particle is a 3x3 square.
    Subclasses may override to get different shapes...
    */
  int rasterX, rasterY;
  int i,j;

  rasterX = 8 * x;
  rasterY = 8 * y;

  rasterY++;
  for (j = 0; j < 3; j++) {
    [r drawPointX: rasterX Y: rasterY Color: particleColor];
    rasterY++;
  }
  rasterY -= 4;
  rasterX++;

  for (i = 0; i < 3; i++) {
    for (j = 0; j < 5; j++) {
      [r drawPointX: rasterX Y: rasterY Color: particleColor];
      rasterY++;
    }
  rasterY -= 5;
  rasterX++;
  }

  rasterY++;
  for (j = 0; j < 3; j++) {
    [r drawPointX: rasterX Y: rasterY Color: particleColor];
    rasterY++;
  }


  return self;
}


@end
