/* 
  WorldManager.h

  Barry McMullin <mcmullin@eeng.dcu.ie>
  17-OCT-1996

*/

#import <swarmobject.h>
#import <simtools.h>

@interface WorldManager : SwarmObject {
  id probeDisplay;

  unsigned worldTime;
  unsigned pmmlcgState;
}

+createBegin: (id) aZone;
-createEnd;

-step;
-update;

-(unsigned) setWorldTime: (unsigned) time;
-(unsigned) getWorldTime;

-setPMMLCGState: (unsigned) newState;
-(unsigned) getPMMLCGState;


-dropWorld;
-createWorldWithX: (int) xSize Y: (int) ySize;
-createEmptyWorldWithX: (int) xSize Y: (int) ySize;
-createDefaultWorld;

-dropAgent: (id) agent;
-fillWithHoles;
-fillWithSubstrate;
-(int) adjustSubstrateNumberBy: (int) adjustment;
-(int) adjustLinkNumberBy: (int) adjustment;
-(int) adjustCatalystNumberBy: (int) adjustment;

-refreshDisplay;

-saveToFileNamed: (char *) filename;
-loadFromFileNamed: (char *) filename;


@end
