/* 
  SCLModelSwarm.m

  Barry McMullin <mcmullin@eeng.dcu.ie>
  30-SEP-1996

*/

#import <simtools.h>

#import "SCLGlobals.h"
#import "VNneighbor.h"
#import "MooreNeighbor.h"
#import "SCLDisplay.h"
#import "AgentManager.h"
#import "ParticleManager.h"
#import "ParameterManager.h"
#import "WorldManager.h"
#import "UserCellEditor.h"
#import "SCLRandomBit.h"

#import "Hole.h"
#import "Substrate.h"
#import "Link.h"
#import "Catalyst.h"
#import "Bond.h"

#import "SCLModelSwarm.h"

@implementation SCLModelSwarm


-buildObjects {
  [super buildObjects];

  worldManager = [WorldManager create: [self getZone]];
  parameterManager = [ParameterManager create: [self getZone]];

  sclRandomBit = [SCLRandomBit alloc]; 
  [sclRandomBit init]; 
  [uniformRandom setGenerator: sclRandomBit];
    // Override the default created in initSwarm...
  [sclRandomBit setPMMLCGState: 42];   // What else?

  vnNeighbor = [VNneighbor create: [self getZone]];
  mooreNeighbor = [MooreNeighbor create: [self getZone]];
  defaultNeighbor = mooreNeighbor;

  /* We build the colormap, and assign (default) colors to
     classes etc. here; it must be done before any agents are
     created, and before the user gets a change to override
     the defaults... */

  colormap = [XColormap create: [self getZone]];

  [colormap setColor: 0 ToName: "black"];
  [Hole setClassColor: 0];

  [colormap setColor: 1 ToName: "red"];
  [Substrate setClassColor: 1];

  [colormap setColor: 2 ToName: "yellow"];
  [Catalyst setClassColor: 2];

  [colormap setColor: 3 ToName: "blue"];
  [Bond setClassColor: 3];
  [Link setClassColor: 3];

  [colormap setColor: 4 ToName: "SkyBlue"];
  [Link setAbsorbedSubstrateColor: 1];

  [colormap setColor: 5 ToName: "SteelBlue"];
  [Link setDisintegratingColor: 5];

  [colormap setColor: 6 ToName: "cyan"];
  [colormap setColor: 7 ToName: "white"];
  

  // Instruct the control panel to wait for a button event: we halt here
  // until someone hits a control panel button so the user can get a
  // chance to fill in parameters before the simulation runs...
  // [controlPanel setStateStopped];
  // [worldManager createDefaultWorld];

  return self;
}


/*
-initialDisplay{
  [worldManager refreshDisplay];
  [controlPanel setStateStopped];

  return self;
}
*/

-step {
  [controlPanel doTkEvents];
  [parameterManager apply];
  [worldManager step];

  return self;
}

-buildActions {
  [super buildActions];
  
  modelActions = [ActionGroup create: [self getZone]];

  [modelActions createActionTo: self message: M(step)];

  modelSchedule = [Schedule createBegin: [self getZone]];
  [modelSchedule setRepeatInterval: 1];
  modelSchedule = [modelSchedule createEnd];
  [modelSchedule at: 0 createAction: modelActions];

  return self;
}

-activateIn: (id) swarmContext {
  [super activateIn: swarmContext];

  [modelSchedule activateIn: self];

  return [self getSwarmActivity];
}


-setStateStopped {
  /* 
    I don't simply use [controlPanel setStateStopped]
    because if we are already stopped that forces a wait
    for a click on some control panel button other than
    stop ... *not* what I want!
  */

  if (getTopLevelActivity()) 
    [getTopLevelActivity() stop]; 
  [controlPanel setState: ControlStateStopped];
  
  return self;
}


@end
