// ObserverSwarm.h				Majority 11

#import "ModelSwarm.h"

#import <simtoolsgui.h>
#import <simtoolsgui/GUISwarm.h>
#import <objectbase.h>
#import <analysis.h>

@interface ObserverSwarm : GUISwarm {
  int displayFrequency;                           // one parameter: update freq

  id displayActions;                              // schedule data structs
  id displaySchedule;

  ModelSwarm * modelSwarm;          		  // the Swarm we're observing

  // Lots of display objects. First, widgets

  id <Colormap> colorMap;                           // allocate colours
  id <ZoomRaster> worldRaster;                       // 2d display widget
  id < EZGraph >  instabilityGraph;
  id <EZGraph> stabilityGraph;
 // Now, higher order display and data objects

 id < Object2dDisplay > voterDisplay;                   // display the voter stances
 id < Object2dDisplay > policyDisplay;                   // display the policy adopted
 id < Object2dDisplay >  proposalDisplay;
}


+createBegin: (id) aZone;
-createEnd;
-eraseRaster;

-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;
-checkToStop;

@end

