#import <objectbase/SwarmObject.h>
#import <defobj/Create.h>
#import <defobj/defalloc.h>
#import <logzone/AsciiMemLogger.h>
#import <logzone/KISSMemLogger.h>
#import <logzone/RMemLogger.h>
#import <logzone/MemLogConsumer.h>

@interface LoggingZone : SwarmObject
{
@public
  id myZone;
  id <MemLogConsumer> myConsumer;
  id parentZone;
}

+ create: aZone;
+ createBegin: aZone;
- (void)setAsciiFilename: (const char*) fname;
- (void)setMemLogConsumer: (id <MemLogConsumer>) aConsumer;
- (void)setRFilename: (const char*) fname;
- (void)setPageSize: (size_t)pageSize;
- createEnd;
- (size_t)getPageSize;
- allocIVars: (Class)aClass; // added code here
- copyIVars: anObject;       // added code here
- (void)freeIVars: anObject; // added code here
- allocIVarsComponent: (Class)aClass;
- copyIVarsComponent: anObject;
- (void)freeIVarsComponent: anObject;
- getComponentZone;
- (void *)alloc: (size_t)size;
- (void)free: (void *) aBlock;
- (void *)allocBlock: (size_t)size;
- (void)freeBlock: (void *)aBlock blockSize: (size_t)size;
- getPopulation;
- (void)describe: outputCharStream;
- (void)describeForEach: outputCharStream;
- (void)mapAllocations: (mapalloc_t)mapalloc;

@end
