/*
    Copyright (C) 2000  Ralf Stephan

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
	or see http://www.gnu.org
*/

#import <gui.h>
#import <simtools.h>
#import <activity.h>
#import "KISSMemLogger.h"
#import "MemLogClassData.h"
#import "TextItemWithStr.h"

#define FONTNAME "*-courier-medium-*-normal-12-*_*_*_*_*_*"
#define LINESIZE 12

@implementation KISSMemLogger

+create: aZone updateEvery: (int) p
{
	KISSMemLogger *obj;
	
	obj = [super create: aZone];

	obj->myObjects = [[Hashtable alloc] initKeyDesc:"*" valueDesc:"@"];

	if (p<1) p=1;
	obj->updateEvery = p;
	obj->myTexts = [List create: aZone];
	obj->myCanvas = nil;
	obj->isCanvasDestroyed = NO;
	
	return obj;
}

//--------------------------------------------------------------------

static timeval_t getTime()
{ 
	id scheduleActivity;
	if ( _activity_current &&
		(scheduleActivity = [_activity_current getScheduleActivity]))
		return [scheduleActivity getCurrentTime];
	
	return -1;
}

- _canvasDeath_ : caller
{
	[myCanvas drop];
	myCanvas = nil;
	isCanvasDestroyed = YES;
	
	return self;
}

// no buildObjects: the window is drawn the first time when we get data
// out of an activity so we can be sure the GUI is up and running.

- (void)consumeRecordTime: (timeval_t) aTime alloc: (int) i
    className: (const char*) cname address: (void*) addr size: (long) size;
{
	if (aTime<0 || isCanvasDestroyed) return;

	if (myCanvas == nil)
	{ // init frame with canvas
		myCanvas = [[Canvas createBegin: [self getZone]] createEnd];
		[myCanvas setWidth: 400 Height: 400];
		[myCanvas setWindowTitle: "Allocated objects in Zone"];
		[myCanvas enableDestroyNotification: self
			notificationMethod: @selector (_canvasDeath_:)];
	}
	
	// Fill the map.
	
	if ([myObjects isKey: cname])
	{
		int n;
		MemLogClassData *data = [myObjects valueForKey: cname];
		
		n = [data getN];
		if (i == YES) ++n;
		else          --n;
		[data setN: n];
	}
	else
		if (i) 
			[myObjects insertKey: cname value: 
				[MemLogClassData create: [self getZone]
					setN: 1 setSize: size]];

	// draw window at time boundary between steps
	if (aTime != lastTime && (aTime % updateEvery) == 0) 
		[self update];
	lastTime = aTime;
}

- update
{
	char buf[256];
	id index, member;
	long sum = 0;

	if (getTime() < 0) return self;  // don't accept msg when not in activity

	// remove/drop all existing text widgets
	[myTexts forEach: M(drop)];
	[myTexts removeAll];
	
	// iterate, create objects, fill myTexts
	{
		GNUHashState state;
		char *akey;
		MemLogClassData *val;

		state = [myObjects initState];
		while ([myObjects nextState: &state 
				key: (const void**)&akey 
				value: (void**)&val])
		{
			int n;
			long size;
			id widget = [TextItemWithStr createBegin: [self getZone]];
			
			n = [val getN];
			size = [val getSize];
			sprintf (buf, "%-24.24s%12ld = %6d * %ld", 
				akey, size*n, n, size);
			sum += size*n;
			
			[widget setText: buf Font: FONTNAME	CenterFlag: NO setCanvas: myCanvas];
			
			[myTexts addFirst: widget];
		}
	}

	[QSort sortObjectsIn: myTexts];

	member = [TextItem createBegin: [self getZone]];
	[[member setText: "-----------------------"] setFont: FONTNAME];
	[[member setCanvas: myCanvas] setCenterFlag: NO];
	[myTexts addFirst: member];

	sprintf (buf, "Total: %ld after step %ld", sum, getTime());
	member = [TextItem createBegin: [self getZone]];
	[[member setText: buf] setFont: FONTNAME];
	[[member setCanvas: myCanvas] setCenterFlag: NO];
	[myTexts addFirst: member];
	
	// fill myCanvas
	index = [myTexts listBegin: [self getZone]];
	{ int y=0;
	for (member = [index next]; [index getLoc] == Member; member = [index next])
		if (member)
		{
			[member setX: 5 Y: y+=LINESIZE];
			[member createEnd];
		}
	}
	[index drop];
	
	[myCanvas pack];
	
	return self;
}
