/*
    Copyright (C) 2000  Ralf Stephan

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
	or see http://www.gnu.org
*/

#include <stdio.h>
#include <string.h>
#import <collections.h>
#import <activity.h>
#import "LoggingZone.h"
#import "AsciiMemLogger.h"
#import "KISSMemLogger.h"
#import "RMemLogger.h"

@implementation LoggingZone

+ createBegin: aZone
{
	LoggingZone *obj;

	obj = [super createBegin: aZone];
	
	obj->myZone = [Zone createBegin: aZone];
	obj->myConsumer = nil;
	obj->parentZone = aZone;
	
	return obj;
}

- (void)setAsciiFilename: (const char*) fname
{
	myConsumer = [AsciiMemLogger create: parentZone fileName: fname];
}

- (void)setMemLogConsumer: (id <MemLogConsumer>) aConsumer
{
	myConsumer = aConsumer;
}

- (void)setRFilename: (const char*) fname
{
	myConsumer = [RMemLogger create: parentZone fileName: fname];
}

- (void)setPageSize: (size_t)pageSize
{
	[myZone setPageSize: pageSize];
}

- createEnd
{
	myZone = [myZone createEnd];
	
	if (myConsumer == nil)
		[self setMemLogConsumer: 
			[KISSMemLogger create: parentZone updateEvery: 0]];
		
	return [super createEnd];
}

+ create: aZone 
{
	id obj;

	obj = [LoggingZone createBegin: aZone];

	[obj setMemLogConsumer: 
		[KISSMemLogger create: aZone updateEvery: 0]];

	return [obj createEnd];
}

//--------------------------------------------------------------

- (size_t)getPageSize
{
	return [myZone getPageSize];
}

static timeval_t getTime()
{ 
	id scheduleActivity;
	if ( _activity_current &&
		(scheduleActivity = [_activity_current getScheduleActivity]))
		return [scheduleActivity getCurrentTime];
	
	return -1;
}

- allocIVars: (Class)aClass
{
	id newObject = [myZone allocIVars: aClass];

	if (strcmp (aClass->name, "ActionHolder"))
	   	[myConsumer consumeRecordTime: getTime()
			alloc: YES
			className: aClass->name
			address: newObject
			size: aClass->instance_size];

	((Object_s*)newObject)->zbits = (unsigned long) self;   
	return newObject;	
}

- copyIVars: anObject
{
	id newObject = [myZone copyIVars: anObject];

	if (strcmp (getClass(anObject)->name, "ActionHolder"))
		[myConsumer consumeRecordTime: getTime()
			alloc: YES
			className: getClass(anObject)->name
			address: newObject
			size: getClass(anObject)->instance_size];

	((Object_s*)newObject)->zbits = (unsigned long) self;   
	return newObject;	
}

- (void)freeIVars: anObject
{
	if (strcmp (getClass(anObject)->name, "ActionHolder"))
		[myConsumer consumeRecordTime: getTime()
			alloc: NO
			className: getClass(anObject)->name
			address: anObject
			size: getClass(anObject)->instance_size];

	[myZone freeIVars: anObject];
}

- allocIVarsComponent: (Class)aClass
{
	return [myZone allocIVarsComponent: aClass];
}
	
- copyIVarsComponent: anObject
{
	return [myZone copyIVarsComponent: anObject];
}
- (void)freeIVarsComponent: anObject
{
	[myZone freeIVarsComponent: anObject];
}

- getComponentZone
{
	return [myZone getComponentZone];
}

- (void *)alloc: (size_t)size
{
	return [myZone alloc: size];
}

- (void)free: (void *) aBlock
{
	[myZone free: aBlock];
}

- (void *)allocBlock: (size_t)size
{
	return [myZone allocBlock: size];
}

- (void)freeBlock: (void *)aBlock blockSize: (size_t)size
{
	[myZone freeBlock: aBlock blockSize: size];
}

- getPopulation
{
	return [myZone getPopulation];
}

- (void)describe: outputCharStream
{
	[myZone describe: outputCharStream];
}

- (void)describeForEach: outputCharStream
{
	[myZone describeForEach: outputCharStream];
}

- (void)mapAllocations: (mapalloc_t)mapalloc
{
	[myZone mapAllocations: mapalloc];
}

@end


