#import <objectbase/SwarmObject.h>
#import <collections.h>
#import "MemLogConsumer.h"

@interface AsciiMemLogger : SwarmObject <MemLogConsumer> 
{
  id myStream;
  id <Map> myObjects;
  const char *myRecordDelim, *myDataDelim;
  BOOL isCumulative;
}

+ create: aZone fileName: (const char*) fname;
+ createBegin: aZone;
- (void)setCumulative;
- (void)setFilename: (char*) fname;
- (void)setOutputStream: aStream;
- (void)setRecordDelim: (const char*) rstr dataDelim: (const char*) dstr;
- createEnd;
- (void)consumeRecordTime: (timeval_t) aTime alloc: (int) i\
    className: (char*) cname address: (void*) addr size: (long) size;
@end
