// **********************************
// from basic code to apps: keep this file unchanged
// **********************************

// MatrixMult.m                                        

#import "MatrixMult.h"

// matrix product
@implementation MatrixMult

- createEnd
{
   [super createEnd];

   return self;
}

- mult: (float *) m1 by: (float *) m2 to: (float *) m3
  row1: (int) r1 col1row2: (int) c1r2 col2: (int) c2
{
  int i, j, l;

  // a matrix is reported in a vector by rows

  for (i=0;i<r1;i++) for (j=0;j<c2;j++)
   {
   m3[i*c2+j]=0;
   for (l=0;l<c1r2;l++) m3[i*c2+j] += m1[i*c1r2+l]*m2[l*c2+j];
   }

  return self;
}
                        
- m1: m1 m2: m2 to: m3
{
  int r1, c1, r2, c2, r3, c3, i, j, l;

  r1=[m1 getNumberOfRows];
  c1=[m1 getNumberOfCols];
  r2=[m2 getNumberOfRows];
  c2=[m2 getNumberOfCols];
  r3=[m3 getNumberOfRows];
  c3=[m3 getNumberOfCols];


  if (c1 != r2 || r1 != r3 || c2 != c3)
     {
     printf("Error: matrix rows and cols not congruent in MatrixMult.\n");
     exit(0);
     }



  for (i=0;i<r1;i++) for (j=0;j<c2;j++)
   {
   [m3 R: i C: j setFrom: 0];
   for (l=0;l<c1;l++) [m3 R: i C: j setFromP: [m1 R: i C: l]*[m2 R: l C: j]];
   }

  return self;
}

- m1: m1 m2: m2 to1: m3
{
  int r1, c1, r2, c2, r3, c3, i, j, l;

  r1=[m1 getNumberOfRows];
  c1=[m1 getNumberOfCols];
  r2=[m2 getNumberOfRows];
  c2=[m2 getNumberOfCols];
  r3=[m3 getNumberOfRows];
  c3=[m3 getNumberOfCols];


  if (c1 != r2 || r1 != r3-1 || c2 != c3)
     {
     printf("Error: matrix rows and cols not congruent in MatrixMult.\n");
     exit(0);
     }



//printf("%d  %d  %d  %d  %d  %d  \n",r1,c1,r2,c2,r3,c3);

  for (i=1;i<r3;i++) for (j=0;j<c2;j++)
   {
   [m3 R: i C: j setFrom: 0];
   for (l=0;l<c1;l++) [m3 R: i C: j setFromP: [m1 R: i-1 C: l]*[m2 R: l C: j]];
   }

  return self;
}

@end
                                     
