// 	$Id: BoolNetBatchSwarm.m,v 1.1.1.1 1998/01/08 00:56:14 alex Exp $	

#define __USE_FIXED_PROTOTYPES__  // for gcc headers

#import "BoolNetBatchSwarm.h"
#import "BoolNetModelSwarm.h"
#import <collections.h>

@implementation BoolNetBatchSwarm

// createBegin: here we set up the default observation parameters.
+createBegin: (id) aZone {
  BoolNetBatchSwarm * obj;

  obj = [super createBegin: aZone];

  obj->displayFrequency = 1;
  return obj;
}

-buildObjects {
  id modelZone;

  [super buildObjects];

  modelZone = [Zone create: [self getZone]];
  boolNetModelSwarm = [BoolNetModelSwarm create: modelZone];

  [boolNetModelSwarm buildObjects];


  // And open a file for writing (see -writeData for comments)
  //  outputFile = fopen("boolNets.data", "w");

  return self;
}  

-buildActions {
  [super buildActions];
  
  [boolNetModelSwarm buildActions];
  

  stopSchedule = [Schedule create: [self getZone]];
  [stopSchedule at: 250 createActionTo: self message: M(stopRunning)];
  
  return self;
}  

-activateIn: (id) swarmContext {

  [super activateIn: swarmContext];


  [boolNetModelSwarm activateIn: self];

/*
  [displaySchedule activateIn: self]; - only used in the GUISwarm!!
*/
  [stopSchedule activateIn: self];

  return [self getSwarmActivity];
}

-go {
  printf("No DISPLAY environment variable was set, so we're running without graphics.\n");
  printf("BoolNet is running for 250 time steps.\n");

  // fprintf(outputFile,"Starting simulation!\n") ;

  [[self getActivity] run];
  return [[self getActivity] getStatus];
}

-writeData {
/*
  fprintf(outputFile, "%d %g\n", getCurrentTime(), -- eg. only
	  [unhappinessAverager getAverage]);
*/
  return self;
}

-stopRunning {
  [getTopLevelActivity() terminate];
  //  fclose(outputFile);
  return self;
}

@end



