// 	$Id: BoolNetObserverSwarm.m,v 1.2 1997/07/10 13:51:53 complex Exp $	

#import "BoolNetObserverSwarm.h"
#import "BoolNetModelSwarm.h"
#import <collections.h>
#import <swarmobject.h>

@implementation BoolNetObserverSwarm

// createBegin: here we set up the default observation parameters.
+createBegin: (id) aZone {
  BoolNetObserverSwarm * obj;
  ProbeMap * probeMap;
  
  obj = [super createBegin: aZone];

  obj->displayFrequency = 1;
  obj->interactiveGraph = 1;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "displayFrequency"
   				    inClass: [self class]]];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "interactiveGraph"
   				    inClass: [self class]]];

  //  [probeMap addProbe: [[probeLibrary getProbeForMessage: "redistribute"
  //		     inClass: [self class]]
  //		setHideResult: 1]];

  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

-createEnd {
  return [super createEnd];
}

-buildObjects {
  id modelZone;	

  [super buildObjects];
  
  modelZone = [Zone create: [self getZone]];
  boolNetModelSwarm = [BoolNetModelSwarm create: modelZone];
  
  // Now create probe objects on the model and ourselves. This gives a
  // simple user interface to let the user change parameters.
  [probeDisplayManager createProbeDisplayFor: boolNetModelSwarm];
  [probeDisplayManager createProbeDisplayFor: self];


  [controlPanel waitForControlEvent];
  if ([controlPanel getState] == ControlStateQuit)
    return self;

  if(interactiveGraph) {
    graphCanvas = [Canvas create: [self getZone]] ;
    [[graphCanvas setHeight: 500] setWidth: 500] ;
    [graphCanvas setWindowTitle: "The Boolean network"] ;
    [globalTkInterp eval: 
      "pack %s -expand 1 -fill both ; update idletasks", 
      [graphCanvas getWidgetName]] ;
  }
 
  [boolNetModelSwarm setGraphCanvas: graphCanvas] ;
  [boolNetModelSwarm buildObjects];

  // no graphs for the moment

  //   activeBoolNets = [EZGraph createBegin: [self getZone]] ;
  //   [activeBoolNets setTitle: "Active BoolNets"] ;
  //   [activeBoolNets setAxisLabelsX: "Time" Y: "BoolNets"] ;
  //   activeBoolNets = [activeBoolNets createEnd] ;
  
  //   [activeBoolNets createTotalSequence: "Survivors" 
  //                       withFeedFrom: [boolNetModelSwarm getEntityList]
  //                        andSelector: M(incident)] ;

  return self;
}  

// -redistribute {
//   [[boolNetModelSwarm getBoolNet] redistribute] ;
//   return self ;
// }

-buildActions {
  [super buildActions];
  
  [boolNetModelSwarm buildActions];
  
  displayActions = [ActionGroup create: [self getZone]];

  // no graophs for the moment
  //  [displayActions createActionTo: activeBoolNets  message: M(step)];

  [displayActions createActionTo: probeDisplayManager message: M(update)];
  [displayActions createActionTo: controlPanel        message: M(doTkEvents)];

  displaySchedule = [Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];

  return self;
}  

-activateIn: (id) swarmContext {

  [super activateIn: swarmContext];

  [boolNetModelSwarm activateIn: self];

  [displaySchedule activateIn: self];

  return [self getSwarmActivity];
}

// You could override the "go" method here if you want something special
// to happen when the model and observer actually start running. But
// the default GUISwarm go is probably good enough.

@end
