// 	$Id: BoolNetModelSwarm.m,v 1.2 1997/07/10 13:51:52 complex Exp $	

#import <stdlib.h>
#import <simtools.h>
#import <boolnet.h>

#import "BoolNetModelSwarm.h"

@implementation BoolNetModelSwarm

+createBegin: (id) aZone {
  BoolNetModelSwarm * obj;
  ProbeMap * probeMap;

  obj = [super createBegin: aZone];

  obj->numElements = 50;
  obj->numConnections = 2;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "numElements"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "numConnections"
				    inClass: [self class]]];

  [probeLibrary setProbeMap: probeMap For: [self class]];

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [BoolNode class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "getBoolState"
				       inClass: [BoolNode class]]];  
  [probeMap addProbe: [probeLibrary getProbeForMessage: "setBoolState:"
  				       inClass: [BoolNode class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "getBoolFunc"
				    inClass: [BoolNode class]]];  
  [probeMap addProbe: [probeLibrary getProbeForMessage: "setBoolFunc:"
				    inClass: [BoolNode class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "getNumInputs"
				    inClass: [BoolNode class]]];    
  [probeMap addProbe: [probeLibrary getProbeForVariable: "getNumOutputs"
				       inClass: [BoolNode class]]];   
  [probeMap addProbe: [probeLibrary getProbeForMessage: "makeLinkFromWithInt:"
				    inClass: [BoolNode class]]];

  [probeLibrary setProbeMap: probeMap For: [BoolNode class]];

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [DiGraphLink class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "from"
				    inClass: [DiGraphLink class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "to"
				    inClass: [DiGraphLink class]]];

  [probeLibrary setProbeMap: probeMap For: [DiGraphLink class]];
  
  return obj;
}


-createEnd {
  return [super createEnd];
}

-getTheBoolNet {
  return theBoolNet ;
}

-getEntityList {
  return entityList ;
}

-getRandomBoolNode {
  //Assumes constant numElements!!!
  return [entityList atOffset: [uniformUnsRand getUnsignedWithMin: 0L withMax: (numElements - 1)]] ;
}

-(int) getNumConnections {
  return numConnections;
}

-setGraphCanvas: aCanvas {
  graphCanvas = aCanvas ;
  return self ;
}

-buildObjects {
  int i;

  int list_length, boolFuncMax ;
  int boolFunc;          // variable for Boolean function
  id index, entity ;
  BOOL boolState;        // variable for Boolean state

  [super buildObjects];

  theBoolNet = [BoolNet createBegin: [self getZone]] ;
  [theBoolNet setCanvas: graphCanvas] ;
  [theBoolNet createEnd] ;

  // create a number of Boolean elements
  for (i = 0 ; i < numElements ; i++){

    boolFuncMax = ldexp(1, ldexp(1, numConnections)) - 1;    //  Boolean function range is given by 2^(2^K) - 1

    // for manual assignment if K = 2 then for "AND" boolFunc = 8; "OR" boolFunc = 14

    boolFunc = [uniformUnsRand getUnsignedWithMin: 0L withMax: boolFuncMax]; // assign randomly within this range

    if ((i%2) == 0)    // alternate between "ON" and "OFF" states...
      boolState = 0;
    else 
      boolState = 1; 
    // should really set the above randomly with function getCoinToss...

    [theBoolNet addNode: [[[[[[[BoolNode createBegin: [self getZone]]
				setCanvas: [theBoolNet getCanvas]] 
			       setBoolNet: theBoolNet]
			      setEntityId: i]
			     setBoolState: boolState] 
			    setBoolFunc: boolFunc] 
			   createEnd]] ;
  }

  entityList = [theBoolNet getNodeList] ;
  
  // randomise the connections - will be specified by GA, later
  list_length = [entityList getCount] ;
  index = [entityList begin: [self getZone]] ;
  
  while( (entity = [index next]) ){    // create random links for each element
  
    if (numConnections > 0) 
      for (i = 0 ; i < numConnections ; i++){  
	[entity makeLinkFrom: 
		  //  [uniformUnsRand getUnsignedWithMin: 0L withMax: (list_length - 1)]
		  [entityList atOffset: [uniformUnsRand getUnsignedWithMin: 0L withMax: (list_length - 1)]]
	  ] ;
      }
  }
  
  [index drop] ;
  
  return self;
}

-buildActions {
  [super buildActions];

  modelActions = [ActionGroup create: [self getZone]];
  [modelActions createActionForEach: entityList message: M(stepRule)];  // apply calculation of new state to each object
  [modelActions createActionForEach: entityList message: M(update)];    // then update the state of the network
  
  modelSchedule = [Schedule createBegin: [self getZone]];
  [modelSchedule setRepeatInterval: 1];
  modelSchedule = [modelSchedule createEnd];
  [modelSchedule at: 0 createAction: modelActions];

  return self;
}

-activateIn: (id) swarmContext {

  [super activateIn: swarmContext];

  [modelSchedule activateIn: self];

  return [self getSwarmActivity];
}

@end










