#import <gui.h>
#import <space.h>
#import "Nail.h"

@implementation Nail

+ create: aZone
{
  return [super create: aZone];
}

- (void) setX: (unsigned) X Y: (unsigned) Y
{
  x = X;
  y = Y;
}

- drawSelfOn: (id <Raster>) aRaster
{
  static id nailPixmap;
  
  if (nailPixmap == nil)
  {
    nailPixmap = [Pixmap createBegin: [self getZone]];
      
    [nailPixmap setDirectory: [arguments getAppDataPath]];
    [nailPixmap setFile: "nail.png"];
    nailPixmap = [nailPixmap createEnd];
    [nailPixmap setRaster: aRaster];
  }
  
  [aRaster draw: nailPixmap X: x Y: y];

  return self;
}

- setWorld: (id <Grid2d>) aWorld
{
  [aWorld putObject: self atX: x Y:y];
  return self;
}
@end
