#import <activity.h>
#import "StringRepresentation.h"
#import "Board.h"
@implementation Board

+ create: aZone
{
        return [super create: aZone];
}
- buildObjects
{
  id nails;
  id <Grid2d> world;
  id colormap;
  int i;
 
  [super buildObjects];
  [controlPanel setStateStopped];
  if ([controlPanel getState] == ControlStateQuit)
          return nil;
  colormap = [Colormap create: self];
  for (i=0; i<32; i++)
    [colormap setColor: i ToRed: 0 Green: 0 Blue: 0];
  balls = [Balls create: [self getZone]];
  nails = [Nails create: [self getZone]];
  worldRaster = [ZoomRaster createBegin: self];
  SET_WINDOW_GEOMETRY_RECORD_NAME (worldRaster);
  worldRaster = [worldRaster createEnd];
  [worldRaster setZoomFactor: 16];
  [worldRaster setWidth: [StringRepresentation getSizeX] 
               Height: [StringRepresentation getSizeY]];
  [worldRaster setColormap: colormap];
  [worldRaster setWindowTitle: "Balls and Nails"];
  [worldRaster pack];                               // draw the window.
  world = [Grid2d create: self 
           setSizeX: [StringRepresentation getSizeX] 
           Y: [StringRepresentation getSizeY]];

  [balls buildObjects];
  [nails buildObjects];
  [balls setWorld: world];
  [nails setWorld: world];
  boardDisplay = [Object2dDisplay create: self
                  setDisplayWidget: worldRaster
                  setDiscrete2dToDisplay: world
                  setDisplayMessage: M(drawSelfOn:)];

  return self;
}
- buildActions
{
  [super buildActions];
  [balls buildActions];
  
  displayActions = [ActionGroup create: self];
  [displayActions createActionTo: worldRaster  message: M(erase)];
  [displayActions createActionTo: boardDisplay  message: M(display)];
  [displayActions createActionTo: worldRaster  message: M(drawSelf)];
  [displayActions createActionTo: actionCache  message: M(doTkEvents)];
  
  displaySchedule = [Schedule create: self setRepeatInterval: 1];
  [displaySchedule at: 0 createAction: displayActions];

  return self;
}
- activateIn: swarmContext
{
  [super activateIn: swarmContext];
  [balls activateIn: self];
  [displaySchedule activateIn: self];

  return [self getSwarmActivity];
}
@end
